// Detta program implementerar ett enkelt program i Java. En fisk
// simmar runt i ett akvarium. Din uppgift blir att utöka detta
// program med möjlighet till fler fiskar, möjlighet att ändra
// storleken på akvariet mm.

// Eftersom koden är avsedd att läsas av nybörjare förklarar
// kommentarerna i koden även olika begrepp i programspråket. Därför
// blir programmet aningen överkommenterat.

// Följande rader är till för att Java skall kunna förstå och tolka
// användandet av standardklasser som Color och JFrame.
//
// Alla klasser och underpaket i paketen java.awt, java.awt.event och
// javax.swing kan nu refereras direkt.

import java.awt.*;          
import java.awt.event.*;    
import javax.swing.*;       
    
// Fish. Denna klass beskriver konceptet fisk. En fisk har en position
// (givet av en koordinat (x,y)), en hastighet, en färg och en
// storlek.


class Fish {

    // Standardkonstanter (for alla instanser av Fish) 
    static int        defaultSize  = 20;
    static Color      defaultColor     = Color.BLUE;

    private int x;
    private int y;
    private int width;
    
    private int size;
    private Color color;

    private int speed = 1;

    private boolean right = true;
    
    // Begränsande rektangulära område inom vilket fisken rör sig 
    private Rectangle box;

    public Fish (int x0, int y0) {
        x = x0;
        y = y0;

        size = defaultSize;
        color = defaultColor;

    }

    public void setColor (Color c) {
        color = c;
    }

    // Sätt nytt begränsande rektangulärt område 
    public void setBoundingBox(Rectangle r) {
        box = r;
    }
    
    public void setSpeed (int s) {
        speed = s;
    }


    public void action () {
      
        if (right) {
            x = x+speed;
        }
        else {
            x = x - speed;
        }
        constrain();
    }

    public void constrain () {
        int width = box.width;
        if (width < x+size) {
            right = false;
        }
        if (x < 0) {
            right = true;
        }
    }
            
    
    // Rita ut en fisk på givet grafiskt område 
    public void paint( Graphics g ) {
            paintRight(g);
    }

    // En fisk som simmar åt vänster
    public void paintLeft (Graphics g){
            
        // Byt till fiskens färg 
        g.setColor( color );

        // Fenan
        int xPoints[] = {x, x+size, x+size, x};
        int yPoints[] = {y, y+size, y-size, y};

        // Rita kroppen
        g.fillOval( x-size/2, y-size/2, size, size );
        // Rita fenan
        g.fillPolygon(xPoints, yPoints, 3);

        // Rita ögat
        g.setColor(Color.WHITE);
        g.fillOval( x-size/4, y-size/4, size/4, size/4);
    }

    // En fisk som simmar åt höger
    public void paintRight (Graphics g){
        // Byt till fiskens färg 
        g.setColor( color );
        // Fenan            
        int xPoints[] = {x, x-size, x-size, x};
        int yPoints[] = {y, y+size, y-size, y};
        // Rita kroppen             
        g.fillOval( x-size/2, y-size/2, size, size );
        // Rita fenan        
        g.fillPolygon(xPoints, yPoints, 3);
        // Rita ögat        
        g.setColor(Color.WHITE);
        g.fillOval( x+size/4, y-size/4, size/4, size/4);
    }
    // Kommentar: Inte så snyggt att ha två nästan likadana
    // metoder. Kan detta lösas bättre?

    // Om fisken har en ljus färg blir ögat nästan osynligt. Kan man
    // göra så att färgen på ögat kan väljas utanför klassen?

}    


// Klassen FishPanel definierar en rityta där fiskarna ritas upp. Den
// ärver klassen JPanel och implementerar ActionListener. Genom att
// implementera ActionListener kan man låta en Timer med jämna
// mellanrum ge ett 'tick' då uppdatering av panelen ska göras.

class FishPanel  extends JPanel implements ActionListener  {
    // Bredd och höjd  
    private int width, height;
            
    // En fisk
    private Fish fish;

    public FishPanel (int width, int height) {
        // Ta reda på bredd och höjd för ritytan
        this.width = width;
        this.height = height;

        // Nånstans i mitten...
        int x = width/2;
        int y = height/2;
        System.out.println(width+" "+height);
        
        // En fisk
        fish = new Fish( x, y);
        
        // Sätt fiskens rektangulära begränsande område (bounding box)
        fish.setBoundingBox(new Rectangle(0, 0, width, height));
        
        // Timer. Skickar en signal var 20e millisekund till panelen
        // som skickas med som ActionListener.

        Timer timer = new Timer(20, this);
        timer.start();
    }


  // När vi får en signal från timern... 
    public void actionPerformed(ActionEvent e) {
        if(width != getWidth() || height != getHeight())
            wasResized(getWidth(),getHeight());
        fish.action();  // Gör vad som är relevant med fisken
        repaint();      // Gör automatiskt ett anrop till
                        // paintComponent()
    }

    // Anropas om fönstret ändrar storlek
    public void wasResized( int newWidth, int newHeight ) {
        System.out.println("Was resized");
        width = newWidth;
        height = newHeight;

    }
    
    // Uppdatera bilden som visas
    // (denna metod anropas automatiskt)
    public void paintComponent( Graphics g ) {

        // Rensa hela ritytan (med svart färg)
        g.setColor( Color.BLACK );
        g.fillRect( 0, 0, width, height );

        // Rita fisken.
        fish.paint( g );

    }
}

// Denna klass definierar det fönster som skapas av programmet. Ett
// fönster (JFrame) skapas där en instans av FishPanel (ritytan)
// placeras.
class Aquarium extends JFrame {

    public Aquarium () {

        
        // Lägg till fiskpanelen i mitten på ramen.
        Container c = getContentPane();

        FishPanel panel = new FishPanel (380, 380);
        c.add(panel, BorderLayout.CENTER);

        setSize(400, 400);     // Storlek
        setLocation(200, 200); // Så att ramen inte hamnar i ett hörn.
        setVisible(true);      // Gör så att ramen syns.

        
        setDefaultCloseOperation(EXIT_ON_CLOSE);
        // Så att programmet avslutas när fönstret stängs.
    }

    public static void main(String[] argv) {
        // Detta kommando ger bättre animering i en del
        // OS. Avkommentera om fisken rör sig ryckigt.
        // System.setProperty("sun.java2d.opengl", "true");

        Aquarium aquarium = new Aquarium();
    }
}    
