/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.PlotWindow;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.Color;

public class SizeIntervalPrecision_
implements PlugIn {
    protected ImageStack stack;
    protected ImagePlus imp;
    int[] parNode;
    int[] imArray;
    int maxP = 0;
    int minP = 0;
    int minSize = 0;
    int maxSize = 0;
    int[] areas;
    double[] sumHistInside;
    double[] sumHistOutside;
    boolean plot = false;
    boolean darkBkg = false;
    boolean ignoreLargeObjects = false;

    public void run(String string) {
        if (this.showDialog()) {
            this.exec();
        }
    }

    public boolean showDialog() {
        GenericDialog genericDialog = new GenericDialog("Size Interval Precision");
        genericDialog.addStringField("MinSize:", "100", 4);
        genericDialog.addStringField("MaxSize:", "2000", 4);
        genericDialog.addCheckbox("IgnoreLargeObjects", true);
        genericDialog.addCheckbox("DarkBkg", true);
        genericDialog.addCheckbox("Plot", true);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return false;
        }
        this.minSize = Integer.valueOf(genericDialog.getNextString());
        this.maxSize = Integer.valueOf(genericDialog.getNextString());
        this.ignoreLargeObjects = genericDialog.getNextBoolean();
        this.darkBkg = genericDialog.getNextBoolean();
        this.plot = genericDialog.getNextBoolean();
        return true;
    }

    public int swapValue(int n) {
        if (this.darkBkg) {
            return n;
        }
        return this.minP + this.maxP - n;
    }

    public double[] swapHist(double[] dArray, int n) {
        if (this.darkBkg) {
            return dArray;
        }
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = dArray[n - 1 - i];
        }
        return dArray2;
    }

    public void exec() {
        int n;
        int n2;
        Object object;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        Object[] objectArray;
        int n8;
        if (IJ.versionLessThan((String)"1.27t")) {
            return;
        }
        this.imp = WindowManager.getCurrentImage();
        this.stack = this.imp.getStack();
        int n9 = this.imp.getWidth();
        int n10 = this.imp.getHeight();
        int n11 = this.imp.getStackSize();
        int n12 = n9 * n10 * n11;
        String string = this.imp.getTitle();
        this.parNode = new int[n12];
        int n13 = this.imp.getType();
        int n14 = 255;
        int n15 = 1;
        this.imArray = new int[n12];
        if (n13 == 1) {
            n14 = 65535;
            n8 = 0;
            objectArray = (short[])this.stack.getPixels(1);
            this.maxP = this.minP = (n7 = n14 & objectArray[0]);
            objectArray = null;
            for (n15 = 1; n15 <= n11; ++n15) {
                objectArray = (short[])this.stack.getPixels(n15);
                n6 = 0;
                for (n5 = 0; n5 < n10; ++n5) {
                    for (n4 = 0; n4 < n9; ++n4) {
                        n7 = n14 & objectArray[n6];
                        n3 = n7;
                        if (n3 < this.minP) {
                            this.minP = n3;
                        }
                        if (n3 > this.maxP) {
                            this.maxP = n3;
                        }
                        this.imArray[n8] = n3;
                        ++n8;
                        ++n6;
                    }
                }
                objectArray = null;
            }
        } else if (n13 == 0) {
            n14 = 255;
            n8 = 0;
            byte[] byArray = (byte[])this.stack.getPixels(1);
            this.maxP = this.minP = n14 & byArray[0];
            byArray = null;
            for (n15 = 1; n15 <= n11; ++n15) {
                byArray = (byte[])this.stack.getPixels(n15);
                n6 = 0;
                for (n5 = 0; n5 < n10; ++n5) {
                    for (n4 = 0; n4 < n9; ++n4) {
                        n3 = n14 & byArray[n6];
                        if (n3 < this.minP) {
                            this.minP = n3;
                        }
                        if (n3 > this.maxP) {
                            this.maxP = n3;
                        }
                        this.imArray[n8] = n3;
                        ++n8;
                        ++n6;
                    }
                }
                byArray = null;
            }
        } else {
            IJ.log((String)"Pixel format not supported");
            return;
        }
        if (!this.darkBkg) {
            for (n8 = 0; n8 < n12; ++n8) {
                this.imArray[n8] = this.minP + this.maxP - this.imArray[n8];
            }
        }
        this.areas = new int[n12];
        for (n8 = 0; n8 < n12; ++n8) {
            this.areas[n8] = 1;
        }
        n7 = this.maxP - this.minP + 1;
        objectArray = new int[n7];
        double[] dArray = new double[n7];
        this.sumHistInside = new double[n7];
        this.sumHistOutside = new double[n7];
        for (n8 = 0; n8 < n12; ++n8) {
            int n16 = this.imArray[n8] - this.minP;
            objectArray[n16] = objectArray[n16] + 1;
        }
        for (n8 = 1; n8 < n7; ++n8) {
            int n17 = n8;
            objectArray[n17] = objectArray[n17] + objectArray[n8 - 1];
        }
        int[] nArray = new int[n12];
        n8 = n12 - 1;
        while (n8 >= 0) {
            int n18 = this.imArray[n8] - this.minP;
            int n19 = objectArray[n18] - 1;
            objectArray[n18] = n19;
            nArray[n19] = n8--;
        }
        for (n8 = 0; n8 < n12; ++n8) {
            this.parNode[n8] = n8;
        }
        for (n8 = n12 - 1; n8 >= 0; --n8) {
            int n20;
            int n21;
            int n22 = n6 = nArray[n8];
            int n23 = n6 / (n9 * n10);
            int n24 = n6 - n23 * (n9 * n10);
            n5 = n24 / n9;
            n4 = n24 - n5 * n9;
            int n25 = n23 - 1;
            int n26 = n23 + 1;
            int n27 = n5 - 1;
            int n28 = n5 + 1;
            int n29 = n4 - 1;
            int n30 = n4 + 1;
            boolean bl = false;
            if (n26 < n11 && this.imArray[n21 = n4 + n9 * (n5 + n26 * n10)] >= this.imArray[n6] && n22 != (n20 = this.findNode(n21))) {
                n22 = this.mergeNodes(n20, n22);
            }
            if (n28 < n10 && this.imArray[n21 = n4 + n9 * (n28 + n23 * n10)] >= this.imArray[n6] && n22 != (n20 = this.findNode(n21))) {
                n22 = this.mergeNodes(n20, n22);
            }
            if (n30 < n9 && this.imArray[n21 = n30 + n9 * (n5 + n23 * n10)] >= this.imArray[n6] && n22 != (n20 = this.findNode(n21))) {
                n22 = this.mergeNodes(n20, n22);
            }
            if (n29 >= 0 && this.imArray[n21 = n29 + n9 * (n5 + n23 * n10)] > this.imArray[n6] && n22 != (n20 = this.findNode(n21))) {
                n22 = this.mergeNodes(n20, n22);
            }
            if (n27 >= 0 && this.imArray[n21 = n4 + n9 * (n27 + n23 * n10)] > this.imArray[n6] && n22 != (n20 = this.findNode(n21))) {
                n22 = this.mergeNodes(n20, n22);
            }
            if (n25 < 0 || this.imArray[n21 = n4 + n9 * (n5 + n25 * n10)] <= this.imArray[n6] || n22 == (n20 = this.findNode(n21))) continue;
            n22 = this.mergeNodes(n20, n22);
        }
        double[] dArray2 = new double[n7];
        double[] dArray3 = new double[n7];
        double[] dArray4 = new double[n7];
        double d = 0.0;
        for (n8 = this.minP; n8 <= this.maxP; ++n8) {
            if (!(this.sumHistInside[n8 - this.minP] > d) || !(this.sumHistInside[n8 - this.minP] > this.sumHistOutside[n8 - this.minP])) continue;
            d = this.sumHistInside[n8 - this.minP];
        }
        boolean bl = false;
        int n31 = this.minP;
        if (d > 0.0) {
            for (n8 = this.minP; n8 <= this.maxP; ++n8) {
                if (this.sumHistInside[n8 - this.minP] > 0.0) {
                    dArray3[n8 - this.minP] = this.sumHistInside[n8 - this.minP] / (this.sumHistInside[n8 - this.minP] + this.sumHistOutside[n8 - this.minP]);
                    dArray4[n8 - this.minP] = this.sumHistInside[n8 - this.minP] / d;
                } else {
                    dArray3[n8 - this.minP] = 0.0;
                    dArray4[n8 - this.minP] = 0.0;
                }
                dArray2[n8 - this.minP] = n8;
            }
            double d2 = 0.5;
            for (n8 = this.minP; n8 != this.maxP; ++n8) {
                if (!(dArray3[n8 - this.minP] > d2) || !(dArray4[n8 - this.minP] > 0.5)) continue;
                d2 = dArray3[n8 - this.minP];
                bl = true;
                n31 = n8;
            }
        }
        if (!bl) {
            n31 = this.maxP + 1;
            IJ.log((String)("No maximum precision found. Using thr: " + this.swapValue(n31)));
        } else {
            IJ.log((String)("thr: " + n31));
        }
        String string2 = "Intensity (thr: " + this.swapValue(n31) + ")";
        if (this.plot) {
            object = new PlotWindow("Size Interval Precision " + string, string2, "Precision", dArray2, this.swapHist(dArray3, n7));
            object.setLimits((double)this.minP, (double)this.maxP, 0.0, 1.0);
            object.setColor(Color.red);
            object.draw();
        }
        n8 = 0;
        if (n13 == 1) {
            for (n15 = 1; n15 <= n11; ++n15) {
                object = (short[])this.stack.getPixels(n15);
                n6 = 0;
                for (n5 = 0; n5 < n10; ++n5) {
                    for (n4 = 0; n4 < n9; ++n4) {
                        n2 = this.imArray[n8];
                        n = n2 >= n31 ? 255 : 0;
                        object[n6] = (ImageStack)((short)n);
                        ++n8;
                        ++n6;
                    }
                }
                object = null;
            }
        } else if (n13 == 0) {
            for (n15 = 1; n15 <= n11; ++n15) {
                object = (byte[])this.stack.getPixels(n15);
                n6 = 0;
                for (n5 = 0; n5 < n10; ++n5) {
                    for (n4 = 0; n4 < n9; ++n4) {
                        n2 = this.imArray[n8];
                        n = n2 >= n31 ? 255 : 0;
                        object[n6] = (ImageStack)((byte)n);
                        ++n8;
                        ++n6;
                    }
                }
                object = null;
            }
        }
        if (n13 != 0) {
            object = new ImageStack(n9, n10);
            boolean bl2 = false;
            for (n15 = 1; n15 <= n11; ++n15) {
                String string3 = this.stack.getSliceLabel(1);
                ImageProcessor imageProcessor = this.stack.getProcessor(1);
                ImageProcessor imageProcessor2 = imageProcessor.convertToByte(bl2);
                this.stack.deleteSlice(1);
                object.addSlice(string3, imageProcessor2);
            }
            this.imp.setStack(null, object);
            object = null;
        }
        this.imp.updateAndRepaintWindow();
        this.parNode = null;
        this.imArray = null;
        this.areas = null;
        this.sumHistInside = null;
        this.sumHistOutside = null;
        objectArray = null;
        dArray2 = null;
        dArray3 = null;
        nArray = null;
        this.imp = null;
        this.stack = null;
        IJ.freeMemory();
    }

    public int findNode(int n) {
        if (this.parNode[n] != n) {
            int n2;
            this.parNode[n] = n2 = this.findNode(this.parNode[n]);
            return n2;
        }
        return n;
    }

    public int mergeNodes(int n, int n2) {
        int n3;
        if (this.imArray[n] == this.imArray[n2]) {
            n3 = Math.max(n, n2);
            int n4 = Math.min(n, n2);
            int n5 = n3;
            this.areas[n5] = this.areas[n5] + this.areas[n4];
            this.parNode[n4] = n3;
        } else {
            this.parNode[n] = n2;
            int n6 = n2;
            this.areas[n6] = this.areas[n6] + this.areas[n];
            double d = this.areas[n];
            if (d >= (double)this.minSize && d <= (double)this.maxSize) {
                for (int i = this.imArray[n]; i != this.imArray[n2]; --i) {
                    int n7 = i - this.minP;
                    this.sumHistInside[n7] = this.sumHistInside[n7] + d;
                }
            } else if (this.ignoreLargeObjects) {
                if (d < (double)this.minSize) {
                    for (int i = this.imArray[n]; i != this.imArray[n2]; --i) {
                        int n8 = i - this.minP;
                        this.sumHistOutside[n8] = this.sumHistOutside[n8] + d;
                    }
                }
            } else {
                for (int i = this.imArray[n]; i != this.imArray[n2]; --i) {
                    int n9 = i - this.minP;
                    this.sumHistOutside[n9] = this.sumHistOutside[n9] + d;
                }
            }
            n3 = n2;
        }
        return n3;
    }

    void error() {
        IJ.showMessage((String)"SizeBasedThr", (String)"Error");
    }
}

