/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;

public class PerObjectEllipsefit_
implements PlugIn {
    protected ImageStack stack;
    protected ImagePlus imp;
    int[] parNode;
    short[] imArray;
    byte[] outputArray;
    double[] ellipseFit;
    double[] majorAxis;
    double[] minorAxis;
    short maxP = 0;
    short minP = 0;
    int minSize = 0;
    int maxSize = 0;
    int minMajorAxis = 0;
    int maxMajorAxis = 0;
    int minMinorAxis = 0;
    int maxMinorAxis = 0;
    double minMajorMinorRatio = 1.0;
    double maxMajorMinorRatio = 10.0;
    double ellipseThr = 0.0;
    int[] areas;
    double[] sumX;
    double[] sumX2;
    double[] sumY;
    double[] sumY2;
    double[] sumXY;
    short[] maxValInObj;
    int width;
    int height;
    int nSlices;
    boolean darkBkg = false;
    int minPeak;
    public static final byte UNDEFINED = 0;
    public static final byte NOT_OBJECT = 1;
    public static final byte MAYBE_NOT_OBJECT = 2;
    public static final byte OBJECT = 3;

    public void run(String string) {
        if (this.showDialog()) {
            this.exec();
        }
    }

    public boolean showDialog() {
        GenericDialog genericDialog = new GenericDialog("Per Object Ellipse fit");
        genericDialog.addStringField("MinSize:", "700", 4);
        genericDialog.addStringField("MaxSize:", "4000", 4);
        genericDialog.addStringField("EllipseThr:", "0.88", 4);
        genericDialog.addStringField("MinMajorAxis:", "30", 4);
        genericDialog.addStringField("MaxMajorAxis:", "200", 4);
        genericDialog.addStringField("MinMinorAxis:", "15", 4);
        genericDialog.addStringField("MaxMinorAxis:", "30", 4);
        genericDialog.addStringField("MinMajorMinorRatio:", "1.5", 4);
        genericDialog.addStringField("MaxMajorMinorRatio:", "10.0", 4);
        genericDialog.addStringField("MinPeak:", "0", 4);
        genericDialog.addCheckbox("DarkBkg", true);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return false;
        }
        this.minSize = Integer.valueOf(genericDialog.getNextString());
        this.maxSize = Integer.valueOf(genericDialog.getNextString());
        this.ellipseThr = Double.valueOf(genericDialog.getNextString());
        this.minMajorAxis = Integer.valueOf(genericDialog.getNextString());
        this.maxMajorAxis = Integer.valueOf(genericDialog.getNextString());
        this.minMinorAxis = Integer.valueOf(genericDialog.getNextString());
        this.maxMinorAxis = Integer.valueOf(genericDialog.getNextString());
        this.minMajorMinorRatio = Double.valueOf(genericDialog.getNextString());
        this.maxMajorMinorRatio = Double.valueOf(genericDialog.getNextString());
        this.minPeak = Integer.valueOf(genericDialog.getNextString());
        this.darkBkg = genericDialog.getNextBoolean();
        return true;
    }

    public void exec() {
        int n;
        int n2;
        int n3;
        short s;
        int n4;
        Object[] objectArray;
        IJ.log((String)"Start");
        long l = System.currentTimeMillis();
        if (IJ.versionLessThan((String)"1.27t")) {
            return;
        }
        this.imp = WindowManager.getCurrentImage();
        this.stack = this.imp.getStack();
        this.width = this.imp.getWidth();
        this.height = this.imp.getHeight();
        this.nSlices = this.imp.getStackSize();
        if (this.nSlices != 1) {
            return;
        }
        int n5 = this.width * this.height;
        String string = this.imp.getTitle();
        this.parNode = new int[n5];
        int n6 = this.imp.getType();
        int n7 = 255;
        boolean bl = true;
        this.imArray = new short[n5];
        this.outputArray = new byte[n5];
        this.ellipseFit = new double[n5];
        this.majorAxis = new double[n5];
        this.minorAxis = new double[n5];
        this.sumX = new double[n5];
        this.sumX2 = new double[n5];
        this.sumY = new double[n5];
        this.sumY2 = new double[n5];
        this.sumXY = new double[n5];
        this.maxValInObj = new short[n5];
        if (n6 == 1) {
            n7 = 65535;
            objectArray = (short[])this.stack.getPixels(1);
            int n8 = n7 & objectArray[0];
            this.maxP = this.minP = (short)(n8 / 2);
            for (n4 = 0; n4 < n5; ++n4) {
                n8 = n7 & objectArray[n4];
                s = (short)(n8 / 2);
                if (s < this.minP) {
                    this.minP = s;
                }
                if (s > this.maxP) {
                    this.maxP = s;
                }
                this.imArray[n4] = s;
            }
        } else if (n6 == 0) {
            n7 = 255;
            objectArray = (byte[])this.stack.getPixels(1);
            this.maxP = this.minP = (s = (short)(n7 & objectArray[0]));
            objectArray = (byte[])this.stack.getPixels(1);
            for (n4 = 0; n4 < n5; ++n4) {
                s = (short)(n7 & objectArray[n4]);
                if (s < this.minP) {
                    this.minP = s;
                }
                if (s > this.maxP) {
                    this.maxP = s;
                }
                this.imArray[n4] = s;
            }
        } else {
            IJ.log((String)"Pixel format not supported");
            return;
        }
        if (!this.darkBkg) {
            for (n4 = 0; n4 < n5; ++n4) {
                this.imArray[n4] = (short)(this.minP + this.maxP - this.imArray[n4]);
            }
        }
        this.areas = new int[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            this.areas[n4] = 1;
        }
        n4 = 0;
        for (n3 = 0; n3 < this.height; ++n3) {
            for (n2 = 0; n2 < this.width; ++n2) {
                this.sumX[n4] = n2;
                this.sumX2[n4] = n2 * n2;
                this.sumY[n4] = n3;
                this.sumY2[n4] = n3 * n3;
                this.sumXY[n4] = n2 * n3;
                ++n4;
            }
        }
        int n9 = this.maxP - this.minP + 1;
        int[] nArray = new int[n9];
        for (n4 = 0; n4 < n5; ++n4) {
            int n10 = this.imArray[n4] - this.minP;
            nArray[n10] = nArray[n10] + 1;
        }
        for (n4 = 1; n4 < n9; ++n4) {
            int n11 = n4;
            nArray[n11] = nArray[n11] + nArray[n4 - 1];
        }
        int[] nArray2 = new int[n5];
        n4 = n5 - 1;
        while (n4 >= 0) {
            int n12 = this.imArray[n4] - this.minP;
            int n13 = nArray[n12] - 1;
            nArray[n12] = n13;
            nArray2[n13] = n4--;
        }
        for (n4 = 0; n4 < n5; ++n4) {
            this.parNode[n4] = n4;
            this.maxValInObj[n4] = this.imArray[n4];
        }
        for (n4 = n5 - 1; n4 >= 0; --n4) {
            int n14;
            int n15;
            int n16 = n = nArray2[n4];
            n3 = n / this.width;
            n2 = n - n3 * this.width;
            int n17 = n3 - 1;
            int n18 = n3 + 1;
            int n19 = n2 - 1;
            int n20 = n2 + 1;
            if (n18 < this.height && this.imArray[n15 = n2 + this.width * n18] >= this.imArray[n] && n16 != (n14 = this.findNode(n15))) {
                n16 = this.mergeNodes(n14, n16);
            }
            if (n20 < this.width && this.imArray[n15 = n20 + this.width * n3] >= this.imArray[n] && n16 != (n14 = this.findNode(n15))) {
                n16 = this.mergeNodes(n14, n16);
            }
            if (n19 >= 0 && this.imArray[n15 = n19 + this.width * n3] > this.imArray[n] && n16 != (n14 = this.findNode(n15))) {
                n16 = this.mergeNodes(n14, n16);
            }
            if (n17 < 0 || this.imArray[n15 = n2 + this.width * n17] <= this.imArray[n] || n16 == (n14 = this.findNode(n15))) continue;
            n16 = this.mergeNodes(n14, n16);
        }
        for (n4 = n5 - 1; n4 >= 0; --n4) {
            n = nArray2[n4];
            if (this.outputArray[n] != 0) continue;
            int n21 = n;
            while (this.imArray[n21] == this.imArray[this.parNode[n21]] && this.outputArray[n21] == 0) {
                n21 = this.parNode[n21];
            }
            if (this.outputArray[n21] == 0) {
                this.findBestEllipseLevel(n, this.minSize, this.maxSize, this.ellipseThr, this.minMajorAxis, this.maxMajorAxis, this.minMinorAxis, this.maxMinorAxis, this.minMajorMinorRatio, this.maxMajorMinorRatio, this.minPeak, -1);
                continue;
            }
            int n22 = n;
            while (n22 != n21) {
                this.outputArray[n22] = this.outputArray[n21];
                n22 = this.parNode[n22];
            }
        }
        for (n4 = n5 - 1; n4 >= 0; --n4) {
            n = nArray2[n4];
            if (this.outputArray[n] != 2) continue;
            this.findBestEllipseLevel(n, this.minSize, this.maxSize, this.ellipseThr, this.minMajorAxis, this.maxMajorAxis, this.minMinorAxis, this.maxMinorAxis, this.minMajorMinorRatio, this.maxMajorMinorRatio, this.minPeak, -1);
        }
        for (n4 = n5 - 1; n4 >= 0; --n4) {
            n = nArray2[n4];
            if (this.outputArray[n] != 2) continue;
            this.findObjBelow(n, this.maxSize);
        }
        if (n6 == 1) {
            short[] sArray = (short[])this.stack.getPixels(1);
            for (n4 = 0; n4 < n5; ++n4) {
                int n23 = this.outputArray[n4] == 3 ? 255 : 0;
                sArray[n4] = (short)n23;
            }
        } else if (n6 == 0) {
            byte[] byArray = (byte[])this.stack.getPixels(1);
            for (n4 = 0; n4 < n5; ++n4) {
                int n24 = this.outputArray[n4] == 3 ? 255 : 0;
                byArray[n4] = (byte)n24;
            }
        }
        if (n6 != 0) {
            ImageStack imageStack = new ImageStack(this.width, this.height);
            boolean bl2 = false;
            String string2 = this.stack.getSliceLabel(1);
            ImageProcessor imageProcessor = this.stack.getProcessor(1);
            ImageProcessor imageProcessor2 = imageProcessor.convertToByte(bl2);
            this.stack.deleteSlice(1);
            imageStack.addSlice(string2, imageProcessor2);
            this.imp.setStack(null, imageStack);
        }
        this.imp.updateAndRepaintWindow();
        this.parNode = null;
        this.imArray = null;
        this.areas = null;
        nArray = null;
        nArray2 = null;
        this.outputArray = null;
        this.ellipseFit = null;
        this.majorAxis = null;
        this.minorAxis = null;
        this.sumX = null;
        this.sumX2 = null;
        this.sumY = null;
        this.sumY2 = null;
        this.sumXY = null;
        this.maxValInObj = null;
        this.imp = null;
        this.stack = null;
        IJ.freeMemory();
        IJ.log((String)"Done");
        long l2 = System.currentTimeMillis();
        IJ.log((String)("TotalTime " + (l2 - l) + " ms"));
    }

    public int findNode(int n) {
        if (this.parNode[n] != n) {
            int n2 = this.findNode(this.parNode[n]);
            return n2;
        }
        return n;
    }

    public boolean findObjBelow(int n, double d) {
        int n2 = n / this.width;
        int n3 = n - n2 * this.width;
        if (this.parNode[n] == n) {
            this.outputArray[n] = 1;
            return false;
        }
        if (this.outputArray[this.parNode[n]] == 3) {
            this.outputArray[n] = 3;
            return true;
        }
        if ((double)this.areas[this.parNode[n]] > d) {
            this.outputArray[n] = 1;
            return false;
        }
        boolean bl = this.findObjBelow(this.parNode[n], d);
        this.outputArray[n] = bl ? this.outputArray[this.parNode[n]] : (byte)1;
        return bl;
    }

    public int findBestEllipseLevel(int n, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, int n2, int n3) {
        double d10;
        double d11;
        if (n3 >= 0) {
            d11 = this.ellipseFit[n3];
            d10 = this.areas[n3];
        } else {
            d11 = 0.0;
            d10 = 0.0;
        }
        int n4 = n;
        while (this.imArray[n] == this.imArray[this.parNode[n]] && this.parNode[n] != n) {
            n = this.parNode[n];
        }
        if (this.outputArray[n] == 3) {
            return n;
        }
        if (this.outputArray[n] == 1) {
            return n3;
        }
        if (this.parNode[n] == n) {
            this.outputArray[n] = 1;
            return n3;
        }
        if ((double)this.areas[n] > d2) {
            this.outputArray[n4] = 1;
            while (n4 != this.parNode[n4] && this.outputArray[this.parNode[n4]] == 0) {
                n4 = this.parNode[n4];
                this.outputArray[n4] = 1;
            }
            return n3;
        }
        double d12 = this.majorAxis[n] / this.minorAxis[n];
        short s = (short)(this.maxValInObj[n] - this.imArray[this.parNode[n]]);
        if ((double)this.areas[n] >= d && this.ellipseFit[n] > d11 && this.ellipseFit[n] > d3 && this.majorAxis[n] >= d4 && this.majorAxis[n] <= d5 && this.minorAxis[n] >= d6 && this.minorAxis[n] <= d7 && d12 >= d8 && d12 <= d9 && s >= n2) {
            d11 = this.ellipseFit[n];
            d10 = this.areas[n];
            n3 = n;
        }
        if ((n3 = this.findBestEllipseLevel(this.parNode[n], d, d2, d3, d4, d5, d6, d7, d8, d9, n2, n3)) >= 0) {
            d11 = this.ellipseFit[n3];
            d10 = this.areas[n3];
        } else {
            d11 = 0.0;
            d10 = 0.0;
        }
        if (n3 >= 0 && this.imArray[n] >= this.imArray[n3]) {
            while (n4 != n) {
                this.outputArray[n4] = 3;
                n4 = this.parNode[n4];
            }
            this.outputArray[n] = 3;
            return n3;
        }
        this.outputArray[n4] = 2;
        if (d10 > (double)this.areas[n4]) {
            this.areas[n4] = 0;
        } else {
            int n5 = n4;
            this.areas[n5] = (int)((double)this.areas[n5] - d10);
        }
        while (n4 != n) {
            n4 = this.parNode[n4];
            this.outputArray[n4] = 2;
            if (d10 > (double)this.areas[n4]) {
                this.areas[n4] = 0;
                continue;
            }
            int n6 = n4;
            this.areas[n6] = (int)((double)this.areas[n6] - d10);
        }
        return n3;
    }

    public int mergeNodes(int n, int n2) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        int n3;
        int n4;
        if (this.imArray[n] == this.imArray[n2]) {
            n4 = Math.max(n, n2);
            n3 = Math.min(n, n2);
        } else {
            n4 = n2;
            n3 = n;
        }
        int n5 = n4;
        this.areas[n5] = this.areas[n5] + this.areas[n3];
        this.parNode[n3] = n4;
        int n6 = n4;
        this.sumX[n6] = this.sumX[n6] + this.sumX[n3];
        int n7 = n4;
        this.sumX2[n7] = this.sumX2[n7] + this.sumX2[n3];
        int n8 = n4;
        this.sumY[n8] = this.sumY[n8] + this.sumY[n3];
        int n9 = n4;
        this.sumY2[n9] = this.sumY2[n9] + this.sumY2[n3];
        int n10 = n4;
        this.sumXY[n10] = this.sumXY[n10] + this.sumXY[n3];
        if (this.maxValInObj[n3] > this.maxValInObj[n4]) {
            this.maxValInObj[n4] = this.maxValInObj[n3];
        }
        if (this.areas[n4] > 1 && (d8 = (d7 = this.sumX2[n4] - this.sumX[n4] * this.sumX[n4] / (double)this.areas[n4]) + (d6 = this.sumY2[n4] - this.sumY[n4] * this.sumY[n4] / (double)this.areas[n4])) > (d5 = Math.sqrt(d8 * d8 - 4.0 * (d7 * d6 - (d4 = this.sumXY[n4] - this.sumX[n4] * this.sumY[n4] / (double)this.areas[n4]) * d4))) && (d3 = Math.PI * (d2 = 2.0 * Math.sqrt((d8 + d5) / (double)(2 * this.areas[n4]))) * (d = 2.0 * Math.sqrt((d8 - d5) / (double)(2 * this.areas[n4])))) > 0.0) {
            this.ellipseFit[n4] = (double)this.areas[n4] / d3;
            this.majorAxis[n4] = 2.0 * d2;
            this.minorAxis[n4] = 2.0 * d;
        }
        return n4;
    }

    void error() {
        IJ.showMessage((String)"PerObjectEllipsefit", (String)"Error");
    }
}

