/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class PerObjectEllipsefit3D_
implements PlugIn {
    protected ImageStack stack;
    protected ImagePlus imp;
    int[] parNode;
    short[] imArray;
    byte[] outputArray;
    double[] ellipseFit;
    double[] majorAxis;
    double[] minorAxis;
    short maxP = 0;
    short minP = 0;
    int minSize = 0;
    int maxSize = 0;
    int minMajorAxis = 0;
    int maxMajorAxis = 0;
    int minMinorAxis = 0;
    int maxMinorAxis = 0;
    double minMajorMinorRatio = 1.0;
    double maxMajorMinorRatio = 10.0;
    double ellipseThr = 0.0;
    int[] areas;
    int[] vol;
    double[] sumX;
    double[] sumX2;
    double[] sumY;
    double[] sumY2;
    double[] sumXY;
    double[] sumZ;
    double[] sumZ2;
    double[] sumXZ;
    double[] sumYZ;
    short[] maxValInObj;
    int width;
    int height;
    int nSlices;
    boolean darkBkg = false;
    int minPeak;
    String outputFileName = "";
    public static final byte UNDEFINED = 0;
    public static final byte NOT_OBJECT = 1;
    public static final byte MAYBE_NOT_OBJECT = 2;
    public static final byte OBJECT = 3;

    public void run(String string) {
        if (this.showDialog()) {
            this.exec();
        }
    }

    public boolean showDialog() {
        GenericDialog genericDialog = new GenericDialog("Per Object Ellipse fit");
        genericDialog.addStringField("MinSize:", "1000", 4);
        genericDialog.addStringField("MaxSize:", "50000", 4);
        genericDialog.addStringField("EllipseThr:", "0.75", 4);
        genericDialog.addStringField("MinMajorAxis:", "10", 4);
        genericDialog.addStringField("MaxMajorAxis:", "30", 4);
        genericDialog.addStringField("MinMinorAxis:", "5", 4);
        genericDialog.addStringField("MaxMinorAxis:", "30", 4);
        genericDialog.addStringField("MinMajorMinorRatio:", "1", 4);
        genericDialog.addStringField("MaxMajorMinorRatio:", "3", 4);
        genericDialog.addStringField("MinPeak:", "0", 4);
        genericDialog.addCheckbox("DarkBkg", true);
        genericDialog.addStringField("OutputFile:", "", 4);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return false;
        }
        this.minSize = Integer.valueOf(genericDialog.getNextString());
        this.maxSize = Integer.valueOf(genericDialog.getNextString());
        this.ellipseThr = Double.valueOf(genericDialog.getNextString());
        this.minMajorAxis = Integer.valueOf(genericDialog.getNextString());
        this.maxMajorAxis = Integer.valueOf(genericDialog.getNextString());
        this.minMinorAxis = Integer.valueOf(genericDialog.getNextString());
        this.maxMinorAxis = Integer.valueOf(genericDialog.getNextString());
        this.minMajorMinorRatio = Double.valueOf(genericDialog.getNextString());
        this.maxMajorMinorRatio = Double.valueOf(genericDialog.getNextString());
        this.minPeak = Integer.valueOf(genericDialog.getNextString());
        this.darkBkg = genericDialog.getNextBoolean();
        this.outputFileName = genericDialog.getNextString();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void exec() {
        IJ.log((String)"Start");
        var1_1 = System.currentTimeMillis();
        if (IJ.versionLessThan((String)"1.27t")) {
            return;
        }
        this.imp = WindowManager.getCurrentImage();
        this.stack = this.imp.getStack();
        this.width = this.imp.getWidth();
        this.height = this.imp.getHeight();
        this.nSlices = this.imp.getStackSize();
        var3_2 = this.width * this.height * this.nSlices;
        var4_3 = this.imp.getTitle();
        this.parNode = new int[var3_2];
        var5_4 = this.imp.getType();
        var6_5 = 255;
        var7_6 = 1;
        this.imArray = new short[var3_2];
        this.outputArray = new byte[var3_2];
        this.ellipseFit = new double[var3_2];
        this.majorAxis = new double[var3_2];
        this.minorAxis = new double[var3_2];
        this.sumX = new double[var3_2];
        this.sumX2 = new double[var3_2];
        this.sumY = new double[var3_2];
        this.sumY2 = new double[var3_2];
        this.sumXY = new double[var3_2];
        this.sumZ = new double[var3_2];
        this.sumZ2 = new double[var3_2];
        this.sumXZ = new double[var3_2];
        this.sumYZ = new double[var3_2];
        this.maxValInObj = new short[var3_2];
        if (var5_4 == 1) {
            var6_5 = 65535;
            var18_7 = 0;
            var24_8 /* !! */  = (short[])this.stack.getPixels(1);
            var23_9 = var6_5 & var24_8 /* !! */ [0];
            this.maxP = this.minP = (short)(var23_9 / 2);
            var24_8 /* !! */  = null;
            for (var7_6 = 1; var7_6 <= this.nSlices; ++var7_6) {
                var24_8 /* !! */  = (short[])this.stack.getPixels(var7_6);
                var19_13 = 0;
                for (var9_12 = 0; var9_12 < this.height; ++var9_12) {
                    for (var8_11 = 0; var8_11 < this.width; ++var8_11) {
                        var23_9 = var6_5 & var24_8 /* !! */ [var19_13];
                        var22_14 = (short)(var23_9 / 2);
                        if (var22_14 < this.minP) {
                            this.minP = var22_14;
                        }
                        if (var22_14 > this.maxP) {
                            this.maxP = var22_14;
                        }
                        this.imArray[var18_7] = var22_14;
                        ++var18_7;
                        ++var19_13;
                    }
                }
                var24_8 /* !! */  = null;
            }
        } else if (var5_4 == 0) {
            var6_5 = 255;
            var18_7 = 0;
            var23_10 = (byte[])this.stack.getPixels(1);
            this.maxP = this.minP = (short)(var6_5 & var23_10[0]);
            var23_10 = null;
            for (var7_6 = 1; var7_6 <= this.nSlices; ++var7_6) {
                var23_10 = (byte[])this.stack.getPixels(var7_6);
                var19_13 = 0;
                for (var9_12 = 0; var9_12 < this.height; ++var9_12) {
                    for (var8_11 = 0; var8_11 < this.width; ++var8_11) {
                        var22_14 = (short)(var6_5 & var23_10[var19_13]);
                        if (var22_14 < this.minP) {
                            this.minP = var22_14;
                        }
                        if (var22_14 > this.maxP) {
                            this.maxP = var22_14;
                        }
                        this.imArray[var18_7] = var22_14;
                        ++var18_7;
                        ++var19_13;
                    }
                }
                var23_10 = null;
            }
        } else {
            IJ.log((String)"Pixel format not supported");
            return;
        }
        IJ.log((String)("nPix: " + var3_2 + " MinP: " + this.minP + " MaxP: " + this.maxP));
        if (!this.darkBkg) {
            for (var18_7 = 0; var18_7 < var3_2; ++var18_7) {
                this.imArray[var18_7] = (short)(this.minP + this.maxP - this.imArray[var18_7]);
            }
        }
        this.areas = new int[var3_2];
        this.vol = new int[var3_2];
        for (var18_7 = 0; var18_7 < var3_2; ++var18_7) {
            this.areas[var18_7] = 1;
            this.vol[var18_7] = 1;
            this.maxValInObj[var18_7] = this.imArray[var18_7];
        }
        var18_7 = 0;
        for (var7_6 = 1; var7_6 <= this.nSlices; ++var7_6) {
            for (var9_12 = 0; var9_12 < this.height; ++var9_12) {
                for (var8_11 = 0; var8_11 < this.width; ++var8_11) {
                    var10_15 = var7_6 - 1;
                    this.sumX[var18_7] = var8_11;
                    this.sumX2[var18_7] = var8_11 * var8_11;
                    this.sumY[var18_7] = var9_12;
                    this.sumY2[var18_7] = var9_12 * var9_12;
                    this.sumXY[var18_7] = var8_11 * var9_12;
                    this.sumZ[var18_7] = var10_15;
                    this.sumZ2[var18_7] = var10_15 * var10_15;
                    this.sumXZ[var18_7] = var8_11 * var10_15;
                    this.sumYZ[var18_7] = var9_12 * var10_15;
                    ++var18_7;
                }
            }
        }
        var23_9 = this.maxP - this.minP + 1;
        var24_8 /* !! */  = (short[])new int[var23_9];
        var25_16 = new double[var23_9];
        for (var18_7 = 0; var18_7 < var3_2; ++var18_7) {
            v0 = this.imArray[var18_7] - this.minP;
            var24_8 /* !! */ [v0] = var24_8 /* !! */ [v0] + 1;
        }
        for (var18_7 = 1; var18_7 < var23_9; ++var18_7) {
            v1 = var18_7;
            var24_8 /* !! */ [v1] = var24_8 /* !! */ [v1] + var24_8 /* !! */ [var18_7 - 1];
        }
        var26_17 = new int[var3_2];
        var18_7 = var3_2 - 1;
        while (var18_7 >= 0) {
            v2 = this.imArray[var18_7] - this.minP;
            v3 = var24_8 /* !! */ [v2] - 1;
            var24_8 /* !! */ [v2] = v3;
            var26_17[v3] = var18_7--;
        }
        for (var18_7 = 0; var18_7 < var3_2; ++var18_7) {
            this.parNode[var18_7] = var18_7;
        }
        for (var18_7 = var3_2 - 1; var18_7 >= 0; --var18_7) {
            var27_26 = var19_13 = var26_17[var18_7];
            var10_15 = var19_13 / (this.width * this.height);
            var17_24 = var19_13 - var10_15 * (this.width * this.height);
            var9_12 = var17_24 / this.width;
            var8_11 = var17_24 - var9_12 * this.width;
            var15_22 = var10_15 - 1;
            var16_23 = var10_15 + 1;
            var13_20 = var9_12 - 1;
            var14_21 = var9_12 + 1;
            var11_18 = var8_11 - 1;
            var12_19 = var8_11 + 1;
            var29_28 = 0;
            if (var16_23 < this.nSlices && this.imArray[var20_25 = var8_11 + this.width * (var9_12 + var16_23 * this.height)] >= this.imArray[var19_13] && var27_26 != (var28_27 = this.findNode(var20_25))) {
                var27_26 = this.mergeNodes(var28_27, var27_26);
            }
            if (var14_21 < this.height && this.imArray[var20_25 = var8_11 + this.width * (var14_21 + var10_15 * this.height)] >= this.imArray[var19_13] && var27_26 != (var28_27 = this.findNode(var20_25))) {
                var27_26 = this.mergeNodes(var28_27, var27_26);
            }
            if (var12_19 < this.width && this.imArray[var20_25 = var12_19 + this.width * (var9_12 + var10_15 * this.height)] >= this.imArray[var19_13] && var27_26 != (var28_27 = this.findNode(var20_25))) {
                var27_26 = this.mergeNodes(var28_27, var27_26);
            }
            if (var11_18 >= 0 && this.imArray[var20_25 = var11_18 + this.width * (var9_12 + var10_15 * this.height)] > this.imArray[var19_13] && var27_26 != (var28_27 = this.findNode(var20_25))) {
                var27_26 = this.mergeNodes(var28_27, var27_26);
            }
            if (var13_20 >= 0 && this.imArray[var20_25 = var8_11 + this.width * (var13_20 + var10_15 * this.height)] > this.imArray[var19_13] && var27_26 != (var28_27 = this.findNode(var20_25))) {
                var27_26 = this.mergeNodes(var28_27, var27_26);
            }
            if (var15_22 < 0 || this.imArray[var20_25 = var8_11 + this.width * (var9_12 + var15_22 * this.height)] <= this.imArray[var19_13] || var27_26 == (var28_27 = this.findNode(var20_25))) continue;
            var27_26 = this.mergeNodes(var28_27, var27_26);
        }
        for (var18_7 = var3_2 - 1; var18_7 >= 0; --var18_7) {
            var19_13 = var26_17[var18_7];
            if (this.outputArray[var19_13] != 0) continue;
            var29_28 = var19_13;
            while (this.imArray[var29_28] == this.imArray[this.parNode[var29_28]] && this.outputArray[var29_28] == 0) {
                var29_28 = this.parNode[var29_28];
            }
            if (this.outputArray[var29_28] == 0) {
                this.findBestEllipseLevel(var19_13, this.minSize, this.maxSize, this.ellipseThr, this.minMajorAxis, this.maxMajorAxis, this.minMinorAxis, this.maxMinorAxis, this.minMajorMinorRatio, this.maxMajorMinorRatio, this.minPeak, -1);
                continue;
            }
            var30_34 = var19_13;
            while (var30_34 != var29_28) {
                this.outputArray[var30_34] = this.outputArray[var29_28];
                var30_34 = this.parNode[var30_34];
            }
        }
        for (var18_7 = var3_2 - 1; var18_7 >= 0; --var18_7) {
            var19_13 = var26_17[var18_7];
            if (this.outputArray[var19_13] != 2) continue;
            this.findBestEllipseLevel(var19_13, this.minSize, this.maxSize, this.ellipseThr, this.minMajorAxis, this.maxMajorAxis, this.minMinorAxis, this.maxMinorAxis, this.minMajorMinorRatio, this.maxMajorMinorRatio, this.minPeak, -1);
        }
        for (var18_7 = var3_2 - 1; var18_7 >= 0; --var18_7) {
            var19_13 = var26_17[var18_7];
            if (this.outputArray[var19_13] != 2) continue;
            this.findObjBelow(var19_13, this.maxSize);
        }
        var18_7 = 0;
        if (this.outputFileName.length() > 0) {
            var29_29 = null;
            try {
                var30_35 = this.outputFileName.replaceAll("%20", " ");
                var31_39 = new File(var30_35);
                var32_40 = var31_39.isFile();
                var33_42 = new FileOutputStream(var31_39, true);
                var29_29 = new PrintStream(var33_42);
                if (!var32_40) {
                    var29_29.println("x0;y0;z0;x;y;z;vol");
                }
                if (var5_4 == 1) {
                    for (var7_6 = 1; var7_6 <= this.nSlices; ++var7_6) {
                        var34_45 /* !! */  = (short[])this.stack.getPixels(var7_6);
                        var19_13 = 0;
                        for (var9_12 = 0; var9_12 < this.height; ++var9_12) {
                            for (var8_11 = 0; var8_11 < this.width; ++var8_11) {
                                var21_44 = this.outputArray[var18_7] == 3 ? 255 : 0;
                                if (this.outputArray[var18_7] == 3 && this.outputArray[this.parNode[var18_7]] != 3) {
                                    var29_29.println(var8_11 + ";" + var9_12 + ";" + (var7_6 - 1) + ";" + this.sumX[var18_7] / (double)this.vol[var18_7] + ";" + this.sumY[var18_7] / (double)this.vol[var18_7] + ";" + this.sumZ[var18_7] / (double)this.vol[var18_7] + ";" + this.vol[var18_7]);
                                }
                                var34_45 /* !! */ [var19_13] = (short)var21_44;
                                ++var18_7;
                                ++var19_13;
                            }
                        }
                        var34_45 /* !! */  = null;
                    }
                }
                if (var5_4 != 0) ** GOTO lbl271
                for (var7_6 = 1; var7_6 <= this.nSlices; ++var7_6) {
                    var34_45 /* !! */  = (byte[])this.stack.getPixels(var7_6);
                    var19_13 = 0;
                    for (var9_12 = 0; var9_12 < this.height; ++var9_12) {
                        for (var8_11 = 0; var8_11 < this.width; ++var8_11) {
                            var21_44 = this.outputArray[var18_7] == 3 ? 255 : 0;
                            if (this.outputArray[var18_7] == 3 && this.outputArray[this.parNode[var18_7]] != 3) {
                                var29_29.println(var8_11 + ";" + var9_12 + ";" + (var7_6 - 1) + ";" + this.sumX[var18_7] / (double)this.vol[var18_7] + ";" + this.sumY[var18_7] / (double)this.vol[var18_7] + ";" + this.sumZ[var18_7] / (double)this.vol[var18_7] + ";" + this.vol[var18_7]);
                            }
                            var34_45 /* !! */ [var19_13] = (byte)var21_44;
                            ++var18_7;
                            ++var19_13;
                        }
                    }
                    var34_45 /* !! */  = null;
                }
            }
            catch (IOException var30_36) {
                IJ.log((String)"Error write file: ".concat(var30_36.getMessage()));
            }
            finally {
                if (var29_29 != null) {
                    var29_29.close();
                }
            }
        } else if (var5_4 == 1) {
            for (var7_6 = 1; var7_6 <= this.nSlices; ++var7_6) {
                var29_30 = (short[])this.stack.getPixels(var7_6);
                var19_13 = 0;
                for (var9_12 = 0; var9_12 < this.height; ++var9_12) {
                    for (var8_11 = 0; var8_11 < this.width; ++var8_11) {
                        var21_44 = this.outputArray[var18_7] == 3 ? 255 : 0;
                        var29_30[var19_13] = (short)var21_44;
                        ++var18_7;
                        ++var19_13;
                    }
                }
                var29_30 = null;
            }
        } else if (var5_4 == 0) {
            for (var7_6 = 1; var7_6 <= this.nSlices; ++var7_6) {
                var29_31 = (byte[])this.stack.getPixels(var7_6);
                var19_13 = 0;
                for (var9_12 = 0; var9_12 < this.height; ++var9_12) {
                    for (var8_11 = 0; var8_11 < this.width; ++var8_11) {
                        var21_44 = this.outputArray[var18_7] == 3 ? 255 : 0;
                        var29_31[var19_13] = (byte)var21_44;
                        ++var18_7;
                        ++var19_13;
                    }
                }
                var29_31 = null;
            }
        }
lbl271:
        // 8 sources

        if (var5_4 != 0) {
            var29_32 = new ImageStack(this.width, this.height);
            var33_43 = false;
            for (var7_6 = 1; var7_6 <= this.nSlices; ++var7_6) {
                var30_38 = this.stack.getSliceLabel(1);
                var31_39 = this.stack.getProcessor(1);
                var32_41 = var31_39.convertToByte(var33_43);
                this.stack.deleteSlice(1);
                var29_32.addSlice(var30_38, var32_41);
            }
            this.imp.setStack(null, var29_32);
            var29_32 = null;
        }
        this.imp.updateAndRepaintWindow();
        this.parNode = null;
        this.imArray = null;
        this.areas = null;
        this.vol = null;
        var24_8 /* !! */  = null;
        var26_17 = null;
        this.outputArray = null;
        this.ellipseFit = null;
        this.majorAxis = null;
        this.minorAxis = null;
        this.sumX = null;
        this.sumX2 = null;
        this.sumY = null;
        this.sumY2 = null;
        this.sumXY = null;
        this.sumZ = null;
        this.sumZ2 = null;
        this.sumXZ = null;
        this.sumYZ = null;
        this.maxValInObj = null;
        this.imp = null;
        this.stack = null;
        IJ.freeMemory();
        IJ.log((String)"Done");
        var29_33 = System.currentTimeMillis();
        IJ.log((String)("TotalTime " + (var29_33 - var1_1) + " ms"));
    }

    public int findNode(int n) {
        if (this.parNode[n] != n) {
            int n2 = this.findNode(this.parNode[n]);
            return n2;
        }
        return n;
    }

    public boolean findObjBelow(int n, double d) {
        int n2 = n / this.width;
        int n3 = n - n2 * this.width;
        if (this.parNode[n] == n) {
            this.outputArray[n] = 1;
            return false;
        }
        if (this.outputArray[this.parNode[n]] == 3) {
            this.outputArray[n] = 3;
            return true;
        }
        if ((double)this.areas[this.parNode[n]] > d) {
            this.outputArray[n] = 1;
            return false;
        }
        boolean bl = this.findObjBelow(this.parNode[n], d);
        this.outputArray[n] = bl ? this.outputArray[this.parNode[n]] : (byte)1;
        return bl;
    }

    public int findBestEllipseLevel(int n, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, int n2, int n3) {
        double d10;
        double d11;
        if (n3 >= 0) {
            d11 = this.ellipseFit[n3];
            d10 = this.areas[n3];
        } else {
            d11 = 0.0;
            d10 = 0.0;
        }
        int n4 = n;
        while (this.imArray[n] == this.imArray[this.parNode[n]] && this.parNode[n] != n) {
            n = this.parNode[n];
        }
        if (this.outputArray[n] == 3) {
            return n;
        }
        if (this.outputArray[n] == 1) {
            return n3;
        }
        if (this.parNode[n] == n) {
            this.outputArray[n] = 1;
            return n3;
        }
        if ((double)this.areas[n] > d2) {
            this.outputArray[n4] = 1;
            while (n4 != this.parNode[n4] && this.outputArray[this.parNode[n4]] == 0) {
                n4 = this.parNode[n4];
                this.outputArray[n4] = 1;
            }
            return n3;
        }
        double d12 = this.majorAxis[n] / this.minorAxis[n];
        short s = (short)(this.maxValInObj[n] - this.imArray[this.parNode[n]]);
        if ((double)this.areas[n] >= d && this.ellipseFit[n] > d11 && this.ellipseFit[n] > d3 && this.majorAxis[n] >= d4 && this.majorAxis[n] <= d5 && this.minorAxis[n] >= d6 && this.minorAxis[n] <= d7 && d12 >= d8 && d12 <= d9 && s >= n2) {
            d11 = this.ellipseFit[n];
            d10 = this.areas[n];
            n3 = n;
        }
        if ((n3 = this.findBestEllipseLevel(this.parNode[n], d, d2, d3, d4, d5, d6, d7, d8, d9, n2, n3)) >= 0) {
            d11 = this.ellipseFit[n3];
            d10 = this.areas[n3];
        } else {
            d11 = 0.0;
            d10 = 0.0;
        }
        if (n3 >= 0 && this.imArray[n] >= this.imArray[n3]) {
            while (n4 != n) {
                this.outputArray[n4] = 3;
                n4 = this.parNode[n4];
            }
            this.outputArray[n] = 3;
            return n3;
        }
        this.outputArray[n4] = 2;
        if (d10 > (double)this.areas[n4]) {
            this.areas[n4] = 0;
        } else {
            int n5 = n4;
            this.areas[n5] = (int)((double)this.areas[n5] - d10);
        }
        while (n4 != n) {
            n4 = this.parNode[n4];
            this.outputArray[n4] = 2;
            if (d10 > (double)this.areas[n4]) {
                this.areas[n4] = 0;
                continue;
            }
            int n6 = n4;
            this.areas[n6] = (int)((double)this.areas[n6] - d10);
        }
        return n3;
    }

    public int mergeNodes(int n, int n2) {
        int n3;
        int n4;
        if (this.imArray[n] == this.imArray[n2]) {
            n4 = Math.max(n, n2);
            n3 = Math.min(n, n2);
        } else {
            n4 = n2;
            n3 = n;
        }
        int n5 = n4;
        this.areas[n5] = this.areas[n5] + this.areas[n3];
        this.vol[n4] = this.areas[n4];
        this.parNode[n3] = n4;
        int n6 = n4;
        this.sumX[n6] = this.sumX[n6] + this.sumX[n3];
        int n7 = n4;
        this.sumX2[n7] = this.sumX2[n7] + this.sumX2[n3];
        int n8 = n4;
        this.sumY[n8] = this.sumY[n8] + this.sumY[n3];
        int n9 = n4;
        this.sumY2[n9] = this.sumY2[n9] + this.sumY2[n3];
        int n10 = n4;
        this.sumXY[n10] = this.sumXY[n10] + this.sumXY[n3];
        int n11 = n4;
        this.sumZ[n11] = this.sumZ[n11] + this.sumZ[n3];
        int n12 = n4;
        this.sumZ2[n12] = this.sumZ2[n12] + this.sumZ2[n3];
        int n13 = n4;
        this.sumXZ[n13] = this.sumXZ[n13] + this.sumXZ[n3];
        int n14 = n4;
        this.sumYZ[n14] = this.sumYZ[n14] + this.sumYZ[n3];
        if (this.maxValInObj[n3] > this.maxValInObj[n4]) {
            this.maxValInObj[n4] = this.maxValInObj[n3];
        }
        if (this.areas[n4] > 1) {
            double d;
            double d2;
            double d3;
            double d4;
            double d5 = this.sumX2[n4] - this.sumX[n4] * this.sumX[n4] / (double)this.areas[n4];
            double d6 = this.sumY2[n4] - this.sumY[n4] * this.sumY[n4] / (double)this.areas[n4];
            double d7 = this.sumZ2[n4] - this.sumZ[n4] * this.sumZ[n4] / (double)this.areas[n4];
            double d8 = this.sumXY[n4] - this.sumX[n4] * this.sumY[n4] / (double)this.areas[n4];
            double d9 = this.sumXZ[n4] - this.sumX[n4] * this.sumZ[n4] / (double)this.areas[n4];
            double d10 = this.sumYZ[n4] - this.sumY[n4] * this.sumZ[n4] / (double)this.areas[n4];
            double d11 = 0.0;
            double d12 = 0.0;
            double d13 = 0.0;
            double d14 = d8 * d8 + d9 * d9 + d10 * d10;
            if (d14 == 0.0) {
                d11 = d5;
                d12 = d6;
                d13 = d7;
            } else {
                double d15;
                double d16;
                double d17;
                double d18;
                double d19;
                d4 = (d5 + d6 + d7) / 3.0;
                d3 = (d5 - d4) * (d5 - d4) + (d6 - d4) * (d6 - d4) + (d7 - d4) * (d7 - d4) + 2.0 * d14;
                d2 = Math.sqrt(d3 / 6.0);
                d = (d5 - d4) / d2;
                double d20 = d * ((d19 = (d6 - d4) / d2) * (d18 = (d7 - d4) / d2) - (d17 = d10 / d2) * d17) + (d16 = d8 / d2) * ((d15 = d9 / d2) * d17 - d16 * d18) + d15 * (d16 * d17 - d19 * d15);
                double d21 = d20 / 2.0;
                double d22 = d21 <= -1.0 ? 1.0471975511965976 : (d21 >= 1.0 ? 0.0 : Math.acos(d21) / 3.0);
                d11 = d4 + 2.0 * d2 * Math.cos(d22);
                d13 = d4 + 2.0 * d2 * Math.cos(d22 + 2.0943951023931953);
                d12 = 3.0 * d4 - d11 - d13;
            }
            d4 = Math.sqrt(5.0 * d11 / (double)this.areas[n4]);
            d3 = Math.sqrt(5.0 * d12 / (double)this.areas[n4]);
            d2 = Math.sqrt(5.0 * d13 / (double)this.areas[n4]);
            d = Math.PI * 4 * d4 * d3 * d2 / 3.0;
            if (d > 0.0) {
                this.ellipseFit[n4] = (double)this.areas[n4] / d;
                this.majorAxis[n4] = 2.0 * d4;
                this.minorAxis[n4] = 2.0 * d2;
            }
        }
        return n4;
    }

    void error() {
        IJ.showMessage((String)"PerObjectEllipsefit3D", (String)"Error");
    }
}

