"""
LocalizeTip
Localize the tip of an object, e.g. a zebrafish
LocalizeTip produces a binary image
"""

import time
import numpy as np
import array
import math
import StringIO

import cellprofiler.module as cpm
import cellprofiler.setting as cps
import cellprofiler.image as cpi

class LocalizeTip(cpm.Module):
	variable_revision_number = 1
	module_name = "LocalizeTip"
	category = "Image Processing"
		
	def create_settings(self):
		#
		# The ImageNameSubscriber knows about the images that were provided
		# by all of the previous modules and will display those to the user
		# in a drop-down choice box.
		#
		self.input_image_name = cps.ImageNameSubscriber("Input image")
		
		#
		# Maximum distance to edge
		#
		self.max_dist_to_edge = cps.Integer("Maximum allowed distance to edge",value=0,minval=0,doc = '''Use this setting to remove avoid getting the tip at the edge of the image.''')

		#
		# The ImageNameProvider tells CellProfiler that this module will
		# provide an image.
		#
		self.output_image_name = cps.ImageNameProvider("Output image", "Tip")
		#
		# If you have a image processing filter, there's a good chance that
		# there are some parameters such as the sigma of a Gaussian or
		# some other sort of scale. You can add those to create_settings
		# on the lines below.
		#
		
	def settings(self):
		#
		# Add your settings to the list below.
		#
		return [self.input_image_name, self.max_dist_to_edge, self.output_image_name]
	
	def run(self, workspace):
		image_set = workspace.image_set
		#
		# Get your image from the image set using the ImageNameProvider
		#
		image = workspace.image_set.get_image(self.input_image_name.value)
		#
		# Get the pixel data from the image. I've chosen to make a copy
		# of the pixel data for safety's sake. It's easy to inadvertantly
		# change the input image's data and that will go against the
		# expectations of your users.
		#
		pixel_data = image.pixel_data.copy()
		
		start = time.clock()
		width = pixel_data.shape[1]
		height = pixel_data.shape[0]
		print("width: %s height: %s" % (str(width), str(height)))
		firstYFirstX = 0
		lastYFirstX = 0
		firstYLastX = 0
		lastYLastX = 0
		firstX = 0
		lastX = 0
		resX = 0
		resY = 0
 
		lastFound = False
		firstFound = False
		for x in range(width-1, -1, -1):
			for y in range(0, height):
				if pixel_data[y, x] > 0:
					if not lastFound:
						firstYLastX = y
					lastFound = True
					lastYLastX = y
					lastX = x
			if lastFound:
				break
		print "firstYLastX " + str(firstYLastX) + " lastYLastX " + str(lastYLastX) + " lastX " + str(lastX)
		if lastFound:
			for x in range(0, width):
				firstFound = False
				for y in range(0, height):				  
					if pixel_data[y, x] > 0:					
						if not firstFound:
							firstYFirstX = y
						firstFound = True
						lastYFirstX = y
						firstX = x
				if firstFound:
					break
		print "firstYFirstX " + str(firstYFirstX) + " lastYFirstX " + str(lastYFirstX) + " firstX " + str(firstX)
		print "maxDist " + str(self.max_dist_to_edge.value)
		if firstFound:
			diffx = lastX - firstX
			midX = firstX + int(diffx/2)
			sumFirst = 0
			for x in range(firstX, midX):			 
				for y in range(0, height):				  
					if pixel_data[y, x] > 0:					
						sumFirst += 1
			sumLast = 0
			for x in range(midX, lastX+1):			  
				for y in range(0, height):				  
					if pixel_data[y, x] > 0:
						sumLast += 1
						
			if lastX >= width - self.max_dist_to_edge.value or firstYLastX <= self.max_dist_to_edge.value or lastYLastX >= height - self.max_dist_to_edge.value:
				print "rule1"
				resX = firstX
				resY = int((firstYFirstX + lastYFirstX)/2)
			elif firstX <= self.max_dist_to_edge.value or firstYFirstX <= self.max_dist_to_edge.value or lastYFirstX >= height - self.max_dist_to_edge.value:
				print "rule2"
				resX = lastX
				resY = int((firstYLastX + lastYLastX)/2)
			elif sumFirst > sumLast:
				print "rule3"
				resX = lastX
				resY = int((firstYLastX + lastYLastX)/2)
			else:
				print "rule4"
				resX = firstX
				resY = int((firstYFirstX + lastYFirstX)/2)
			
			print "diffx " + str(diffx)
			print "sumFirst " + str(sumFirst) + " sumLast " + str(sumLast)
			print "resX " + str(resX) + " resY " + str(resY)
		end = time.clock()
		elapsed = end - start
		print("LocalizeTip: %s s" % str(elapsed))
		pixel_data = np.zeros_like(pixel_data)
		pixel_data[resY, resX] = 1

		
		#
		# Make a cpi.Image using the transformed pixel data
		# put your image back in the image set.
		#
		output_image = cpi.Image(pixel_data)
		image_set.add(self.output_image_name.value, output_image)
		#
		# Store the input and output images in the workspace so that
		# they can be displayed later
		#
		if workspace.show_frame:
			workspace.display_data.input_image = image.pixel_data
			workspace.display_data.output_image = pixel_data

	#
	# The display interface is changing / has changed.
	# This is a recipe to make yours work with both
	#
	def display(self, workspace, figure=None):
		if figure is None:
			figure = workspace.create_or_find_figure(subplots=(2, 1))
		else:
			figure.set_subplots((2, 1))
		figure.subplot_imshow_grayscale(
			0, 0, workspace.display_data.input_image,
			title = self.input_image_name.value)
		figure.subplot_imshow_grayscale(
			1, 0, workspace.display_data.output_image,
			title = self.output_image_name.value, 
			sharexy = figure.subplot(0,0))		  
		
	def is_interactive(self):
		return False
