/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

class TimeKeeper
implements ActionListener {
    private Player thePlayer;
    private int clock;
    private int increment;
    private int clockStep = 100;
    private Timer timer = new Timer(this.clockStep, this);
    private boolean timerIsRunning;
    private boolean timerIsPaused;

    TimeKeeper(Player thePlayer, int clock, int increment) {
        this.thePlayer = thePlayer;
        this.clock = clock;
        this.increment = increment;
    }

    void incrementClock() {
        this.clock += this.increment;
    }

    void start() {
        this.timer.start();
        this.timerIsRunning = true;
    }

    void stop() {
        this.timer.stop();
        this.timerIsRunning = false;
    }

    void pause() {
        this.timer.stop();
        this.timerIsPaused = this.timerIsRunning;
    }

    void restart() {
        if (this.timerIsPaused) {
            this.timer.start();
        }
    }

    String timeToString(int time) {
        int minutes = time / 60000;
        int seconds = time % 60000 / 1000;
        int secondsFirstDigit = seconds / 10;
        int secondsSecondDigit = seconds % 10;
        Object result = "";
        if (minutes > 0) {
            result = (String)result + minutes;
        }
        result = (String)result + ":" + secondsFirstDigit;
        result = (String)result + secondsSecondDigit;
        return result;
    }

    String timeToString() {
        return this.timeToString(this.clock);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.clock -= this.clockStep;
        if (this.clock % 1000 == 0) {
            this.thePlayer.showTime(true);
            this.thePlayer.sendTime(this.timeToString());
        }
        if (this.clock < 0) {
            this.timer.stop();
            this.thePlayer.loseOnTime();
        }
    }
}

