/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;

class TilePosition
implements Serializable {
    int x;
    int y;

    TilePosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    TilePosition add(TilePosition pos) {
        return new TilePosition(this.x + pos.x, this.y + pos.y);
    }

    TilePosition transpose() {
        return new TilePosition(7 - this.x, 7 - this.y);
    }

    boolean isLegal() {
        return this.x >= 0 && this.y >= 0 && this.x <= 7 && this.y <= 7;
    }

    boolean isFinalRank() {
        return this.y == 0 || this.y == 7;
    }

    public boolean equals(Object obj) {
        TilePosition pos = (TilePosition)obj;
        return this.x == pos.x && this.y == pos.y;
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }
}

