/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

class Tile {
    private static final int SIZE = 60;
    private static final int LABEL_OFFSET = 5;
    private static final Color lightContrColor = new Color(255, 230, 204);
    private static final Color darkContrColor = new Color(153, 79, 0);
    private static final Color lightColor = new Color(166, 166, 166);
    private static final Color darkColor = new Color(102, 102, 102);
    private static final Color markColor = Color.BLUE;
    private static final Color alertColor = Color.RED;
    private static final int markWidth = 6;
    private final TilePosition pos;
    private final String name;
    private final boolean isDark;
    private Color color;
    private int controlValue;
    private boolean isVisible;
    private boolean markedForLastMove = false;
    private boolean showMyControls = true;
    private Piece inhabitant;

    Tile(TilePosition pos, String name) {
        this.pos = pos;
        this.name = name;
        this.isDark = (pos.x + pos.y) % 2 == 1;
    }

    String getName() {
        return this.name;
    }

    boolean isControlled() {
        return this.controlValue > 0;
    }

    boolean isControlledByOpponent() {
        return this.controlValue < 0;
    }

    void addControl(int increment) {
        this.controlValue += increment;
    }

    void setZeroControl() {
        this.controlValue = 0;
    }

    void makeVisible() {
        this.isVisible = true;
    }

    void makeInvisible() {
        this.isVisible = false;
    }

    void markForLastMove() {
        this.markedForLastMove = true;
    }

    void eraseMarkForLastMove() {
        this.markedForLastMove = false;
    }

    void toggleShowControl() {
        this.showMyControls = !this.showMyControls;
    }

    Piece getInhabitant() {
        return this.inhabitant;
    }

    void setInhabitant(Piece piece) {
        this.inhabitant = piece;
    }

    boolean isFree() {
        return this.inhabitant == null;
    }

    boolean hasMovablePiece() {
        return !this.isFree() && !this.isControlledByOpponent() && this.inhabitant.isMine();
    }

    void paint(Graphics g) {
        if (!this.isVisible) {
            return;
        }
        this.color = this.isDark ? darkColor : lightColor;
        if (this.isControlled() && this.showMyControls || this.isControlledByOpponent() && !this.showMyControls) {
            this.color = this.isDark ? darkContrColor : lightContrColor;
        }
        if (this.inhabitant != null && !this.inhabitant.isMobile()) {
            this.color = alertColor;
        }
        if (this.markedForLastMove) {
            g.setColor(markColor);
            g.fillRect(this.pos.x * 60, this.pos.y * 60, 60, 60);
            g.setColor(this.color);
            g.fillRect(this.pos.x * 60 + 6, this.pos.y * 60 + 6, 48, 48);
        } else {
            g.setColor(this.color);
            g.fillRect(this.pos.x * 60, this.pos.y * 60, 60, 60);
        }
        if (!this.isFree()) {
            this.inhabitant.paint(g);
        }
        this.paintLabel(g);
    }

    private void paintLabel(Graphics g) {
        if (this.isDark) {
            g.setColor(Color.WHITE);
        } else {
            g.setColor(Color.BLACK);
        }
        g.setFont(new Font("TimesRoman", 1, 12));
        if (this.isBottom()) {
            g.drawString(String.valueOf(this.name.charAt(0)), this.pos.x * 60 + 30 - 5, (this.pos.y + 1) * 60 - 2);
        }
        if (this.isLeft()) {
            g.drawString(String.valueOf(this.name.charAt(1)), 0, this.pos.y * 60 + 30 - 2);
        }
    }

    private boolean isBottom() {
        return this.pos.y == 7;
    }

    private boolean isLeft() {
        return this.pos.x == 0;
    }
}

