/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class Start {
    static final String VERSION = "1.2.1";
    private final JTextField IPField = new JTextField(20);
    private final JTextField portField = new JTextField(5);
    private JFrame theFrame;
    private JPanel startPanel;
    private ServerSocket serverSocket;
    private InputStream is;
    private ObjectInputStream inputFromOpponent;
    private OutputStream os;
    private ObjectOutputStream outputToOpponent;
    private boolean isServer = false;
    boolean fogOfWar = false;
    private int port;
    private String IP;

    Start(String defaultIP, int defaultPort) {
        this.IP = defaultIP;
        this.port = defaultPort;
        this.setUpFirstFrame();
    }

    void reStart() {
        if (this.isServer) {
            this.waitForConnection();
        } else {
            new Start(this.IP, this.port);
        }
    }

    void reStartFromBeginning() {
        new Start(this.IP, this.port);
    }

    private void setUpFirstFrame() {
        this.theFrame = new JFrame("PSC: Parrow's Synchronous Chess 1.2.1");
        this.startPanel = new JPanel();
        this.startPanel.setPreferredSize(new Dimension(700, 120));
        this.theFrame.setDefaultCloseOperation(3);
        this.addFields();
        this.addButtons();
        this.theFrame.add(this.startPanel);
        this.theFrame.pack();
        this.theFrame.setVisible(true);
    }

    private void addFields() {
        this.IPField.setEditable(true);
        this.IPField.setText(this.IP);
        this.portField.setText(String.valueOf(this.port));
        this.portField.setEditable(true);
        this.startPanel.add(new JLabel("EITHER Connect to IP:"));
        this.startPanel.add(this.IPField);
        this.startPanel.add(new JLabel("Port number:"));
        this.startPanel.add(this.portField);
        this.startPanel.add(new JLabel("OR accept incoming connection"));
    }

    private void addButtons() {
        JButton ruleButton = new JButton("Show rules");
        ruleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Start.this.showRules();
            }
        });
        JButton goButton = new JButton("Connect");
        goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Start.this.go();
            }
        });
        JButton acceptButton = new JButton("Accept");
        acceptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Start.this.waitForConnection();
            }
        });
        JCheckBox fogOfWarBox = new JCheckBox("Fog of War");
        fogOfWarBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Start.this.fogOfWar = !Start.this.fogOfWar;
            }
        });
        this.startPanel.add(ruleButton);
        this.startPanel.add(goButton);
        this.startPanel.add(acceptButton);
        this.startPanel.add(fogOfWarBox);
    }

    private void go() {
        this.IP = this.IPField.getText();
        this.port = Integer.parseInt(this.portField.getText());
        try {
            this.startClient(this.IP, this.port);
        }
        catch (IOException e) {
            this.failedConnection();
        }
    }

    private void failedConnection() {
        JOptionPane.showMessageDialog(this.theFrame, "Connection failed");
    }

    private void failedServer() {
        JOptionPane.showMessageDialog(this.theFrame, "ServerSocket failed");
    }

    private void startClient(String IP, int port) throws IOException {
        Socket opponentSocket = new Socket(IP, port);
        this.theFrame.dispose();
        this.getStreams(opponentSocket);
        new Player(true, this.fogOfWar, this.inputFromOpponent, this.outputToOpponent, this);
    }

    private void getStreams(Socket socket) {
        try {
            this.is = socket.getInputStream();
            this.os = socket.getOutputStream();
            this.outputToOpponent = new ObjectOutputStream(this.os);
            this.inputFromOpponent = new ObjectInputStream(this.is);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("CANNOT GET STREAMS");
        }
    }

    private void showRules() {
        JFrame ruleFrame = new JFrame("PSC rules");
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("PSC.txt");
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        String text = reader.lines().collect(Collectors.joining("\n"));
        JTextArea ruleArea = new JTextArea(text);
        ruleArea.setEditable(false);
        ruleArea.setFont(new Font("TimesRoman", 0, 24));
        ruleArea.setBackground(new Color(230, 204, 179));
        JScrollPane ruleScrollArea = new JScrollPane(ruleArea);
        ruleScrollArea.setVerticalScrollBarPolicy(22);
        ruleFrame.add(ruleScrollArea);
        ruleFrame.pack();
        ruleFrame.setVisible(true);
    }

    private void waitForConnection() {
        String myIP;
        this.port = Integer.parseInt(this.portField.getText());
        this.isServer = true;
        this.theFrame.remove(this.startPanel);
        this.theFrame.setDefaultCloseOperation(0);
        JPanel waitPanel = new JPanel();
        waitPanel.setPreferredSize(new Dimension(600, 100));
        JButton quitButton = new JButton("Quit");
        quitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Start.this.quit();
            }
        });
        try {
            myIP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (IOException e) {
            myIP = "unknown";
        }
        waitPanel.add(new JLabel("Waiting for connection on IP " + myIP + " on port " + this.port));
        waitPanel.add(quitButton);
        this.theFrame.add(waitPanel);
        this.theFrame.pack();
        this.theFrame.setVisible(true);
        new StartServer().start();
    }

    private void closeServer() {
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            } else {
                this.failedServer();
            }
        }
        catch (IOException e) {
            System.out.println("Error in closing");
        }
        System.exit(0);
    }

    private void quit() {
        this.closeServer();
    }

    private class StartServer
    extends Thread {
        private StartServer() {
        }

        @Override
        public void run() {
            try {
                Start.this.serverSocket = new ServerSocket(Start.this.port);
                Socket socket = Start.this.serverSocket.accept();
                Start.this.serverSocket.close();
                Start.this.theFrame.dispose();
                Start.this.getStreams(socket);
                new Player(false, Start.this.fogOfWar, Start.this.inputFromOpponent, Start.this.outputToOpponent, Start.this);
            }
            catch (IOException e) {
                Start.this.closeServer();
            }
        }
    }
}

