/*
 * Decompiled with CFR 0.152.
 */
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

class Player {
    private final Board theBoard;
    private final Communicator theCommunicator;
    private final GUI theGUI;
    private final Start theStart;
    private final int STARTINGTIME = 180000;
    private final int INCREMENT = 2000;
    private final TimeKeeper theTimeKeeper;
    private final PieceColor myColor;
    private boolean fogOfWar;
    private boolean drawIsBeingConsidered = false;
    private boolean drawHasBeenOffered = false;
    private String opponentTime;

    Player(boolean decideColor, boolean fogOfWar, ObjectInputStream input, ObjectOutputStream output, Start theStart) {
        this.theStart = theStart;
        this.fogOfWar = fogOfWar;
        this.theCommunicator = new Communicator(input, output, this);
        this.theTimeKeeper = new TimeKeeper(this, 180000, 2000);
        this.opponentTime = this.theTimeKeeper.timeToString(180000);
        this.myColor = this.getColor(decideColor);
        this.theBoard = new Board(this.myColor, this);
        this.theGUI = new GUI(this);
        this.checkInitials();
        this.theCommunicator.startToListenForMoves();
        this.showTime(false);
        Move.resetMoveNumber();
    }

    Board getBoard() {
        return this.theBoard;
    }

    boolean getFogOfWar() {
        return this.fogOfWar;
    }

    private PieceColor getColor(Boolean determineColor) {
        PieceColor myColor = Math.random() > 0.5 ? PieceColor.White : PieceColor.Black;
        this.theCommunicator.sendColor(myColor);
        PieceColor opponentColor = this.theCommunicator.getColor();
        if (!determineColor.booleanValue()) {
            myColor = opponentColor.opposite();
        }
        return myColor;
    }

    private void checkInitials() {
        InitialMessage message = new InitialMessage(this.fogOfWar, "1.2.1");
        this.theCommunicator.sendInitialMessage(message);
        InitialMessage opponentsMessage = this.theCommunicator.getInitialMessage();
        if (!message.checkFogOfWar(opponentsMessage)) {
            this.theGUI.showDisagreement("Disagreeing on Fog of War");
            this.goFromBeginning();
        }
        if (!message.checkVersion(opponentsMessage)) {
            this.theGUI.showDisagreement("Incompatible versions. You have 1.2.1 and opponent has " + opponentsMessage.getVersion());
            this.goFromBeginning();
        }
    }

    private void sendMoveToOpponent(Message message) {
        this.theTimeKeeper.incrementClock();
        if (this.drawIsBeingConsidered) {
            this.rejectDraw();
        }
        this.showTime(false);
        this.sendTime(this.theTimeKeeper.timeToString());
        this.theCommunicator.sendMove(message);
    }

    void sendMoveToOpponent(TilePosition source, TilePosition target, PieceType promotionType) {
        this.sendMoveToOpponent(new Message(source, target, promotionType));
    }

    void getMessageFromOpponent(Message message) {
        if (message.acceptDraw || this.drawHasBeenOffered && message.offerDraw) {
            this.drawByAgreement();
        } else if (message.rejectDraw) {
            this.myDrawOfferHasBeenRejected(message);
        } else if (message.offerDraw) {
            this.getDrawOffer();
        } else if (message.resign) {
            this.opponentResigned();
        } else if (message.loseOnTime) {
            this.showWinOnTime();
        } else if (message.time != null) {
            this.updateOpponentTime(message.time);
        } else {
            this.sendMoveToBoard(message);
        }
    }

    private void sendMoveToBoard(Message message) {
        Move theMove = new Move(message.source, message.target, message.promotionType, this.theBoard);
        this.theBoard.incomingMoveFromOpponent(theMove);
    }

    void sendTime(String time) {
        this.theCommunicator.sendMove(new Message(time));
    }

    private void updateOpponentTime(String time) {
        this.opponentTime = time;
        this.showTime(false);
    }

    void showTime(boolean isRunning) {
        this.theGUI.showTime(isRunning, this.theTimeKeeper.timeToString(), this.opponentTime);
    }

    void startClock() {
        this.theTimeKeeper.start();
        this.showTime(true);
    }

    void stopClock() {
        this.theTimeKeeper.stop();
        this.showTime(false);
    }

    void stopGettingMoves() {
        this.theBoard.stopGettingMoves();
        this.theTimeKeeper.stop();
    }

    void record(String move) {
        this.theGUI.record(move);
    }

    void resign() {
        if (this.theGUI.confirmResign()) {
            Message message = new Message();
            message.resign();
            this.sendMoveToOpponent(message);
            this.showIResign();
        }
    }

    void loseOnTime() {
        Message message = new Message();
        message.loseOnTime();
        this.sendMoveToOpponent(message);
        this.showILoseOnTime();
    }

    void offerDraw() {
        this.drawHasBeenOffered = true;
        this.showIOfferDraw();
        this.theBoard.stopGettingMoves();
        this.recordDrawOffer(true);
        Message message = new Message();
        message.offerDraw();
        this.sendMoveToOpponent(message);
        this.theTimeKeeper.pause();
    }

    private void recordDrawOffer(boolean myOffer) {
        if (myOffer && this.myColor == PieceColor.White || !myOffer && this.myColor == PieceColor.Black) {
            this.theGUI.record("W offers draw\n");
        } else {
            this.theGUI.record("B offers draw\n");
        }
    }

    void rejectDraw() {
        this.drawIsBeingConsidered = false;
        Message rejectMessage = new Message();
        rejectMessage.rejectDraw();
        this.theCommunicator.sendMove(rejectMessage);
        this.theGUI.showTitle();
    }

    void commError(String reason) {
        this.showOutOfSynch(reason);
    }

    private void opponentResigned() {
        this.showOpponentResigned();
    }

    private void drawByAgreement() {
        this.showDrawByAgreement();
    }

    private void getDrawOffer() {
        this.drawIsBeingConsidered = true;
        this.recordDrawOffer(false);
        this.showDrawOffer();
    }

    private void myDrawOfferHasBeenRejected(Message message) {
        this.theGUI.showTitle();
        this.drawHasBeenOffered = false;
        if (message.source != null) {
            this.sendMoveToBoard(message);
        }
        this.theBoard.reactivate();
        this.theTimeKeeper.restart();
    }

    void acceptDraw() {
        Message message = new Message();
        message.acceptDraw();
        this.sendMoveToOpponent(message);
        this.drawIsBeingConsidered = false;
        this.showDrawByAgreement();
    }

    private String outcome(boolean iWin) {
        if (iWin && this.myColor == PieceColor.White) {
            return "      1 - 0\n";
        }
        if (!iWin && this.myColor == PieceColor.Black) {
            return "      1 - 0\n";
        }
        return "      0 - 1\n";
    }

    void showWin() {
        this.theGUI.record(this.outcome(true));
        this.theGUI.showFinal("YOU WIN!");
    }

    void showDraw(String reason) {
        this.theGUI.record("    1/2 - 1/2\n");
        this.theGUI.showFinal("DRAW! " + reason);
    }

    void showWinOnTime() {
        this.theGUI.record(this.outcome(true));
        this.theBoard.makeAllVisible();
        this.theGUI.showFinal("OPPONENT LOST ON TIME");
    }

    void showLose() {
        this.theGUI.record(this.outcome(false));
        this.theGUI.showFinal("YOU LOSE!");
    }

    void showILoseOnTime() {
        this.theGUI.record(this.outcome(false));
        this.theBoard.makeAllVisible();
        this.theGUI.showFinal("YOU LOSE ON TIME");
    }

    private void showIOfferDraw() {
        this.theGUI.showYouOfferDraw();
    }

    private void showDrawOffer() {
        this.theGUI.showDrawOffer();
    }

    private void showDrawByAgreement() {
        this.theGUI.record("    1/2 - 1/2\n");
        this.theBoard.makeAllVisible();
        this.theGUI.showFinal("Drawn by agreement");
    }

    private void showIResign() {
        this.theGUI.record(this.outcome(false));
        this.theBoard.makeAllVisible();
        this.theGUI.showFinal("You have resigned");
    }

    private void showOpponentResigned() {
        this.theGUI.record(this.outcome(true));
        this.theBoard.makeAllVisible();
        this.theGUI.showFinal("Opponent has resigned");
    }

    private void showOutOfSynch(String s) {
        this.theGUI.record("Out of Synch " + s + "\n");
        this.theGUI.showFinal("Out of Synch" + s);
    }

    void goAgain() {
        this.theCommunicator.stopListening();
        this.theGUI.close();
        this.theStart.reStart();
    }

    void goFromBeginning() {
        this.theCommunicator.stopListening();
        this.theGUI.close();
        this.theStart.reStartFromBeginning();
    }
}

