/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;

abstract class Piece {
    private final Board board;
    private BufferedImage appearance;
    private final int SIZE;
    private final PieceColor color;
    private char designator;
    private Tile tile;
    private TilePosition position;
    private DraggedPosition posWhenDragged;
    private boolean isCurrentlyDragged = false;
    private boolean hasMoved = false;

    Piece(Board board, TilePosition pos, PieceColor color) {
        this.SIZE = 60;
        this.board = board;
        this.position = pos;
        this.color = color;
        this.tile = board.tile(pos);
        this.tile.setInhabitant(this);
    }

    abstract ArrayList<TilePosition> computeAttacks();

    static final BufferedImage getPieceImage(PieceColor color, char designator) {
        BufferedImage image = null;
        Object name = color == PieceColor.White ? "W" : "B";
        name = (String)name + designator;
        InputStream is = Main.class.getResourceAsStream("Pieces/" + (String)name + ".png");
        try {
            image = ImageIO.read(is);
        }
        catch (IOException e) {
            System.out.println("Failed loading piece image");
        }
        return image;
    }

    private final void getImage() {
        this.appearance = Piece.getPieceImage(this.color, this.designator);
    }

    static final Piece pieceFactory(Board board, TilePosition pos, PieceType type, PieceColor pc) {
        Piece newPiece = null;
        switch (type) {
            case KING: {
                newPiece = new King(board, pos, pc);
                break;
            }
            case PAWN: {
                newPiece = new Pawn(board, pos, pc);
                break;
            }
            case KNIGHT: {
                newPiece = new Knight(board, pos, pc);
                break;
            }
            case BISHOP: {
                newPiece = new Bishop(board, pos, pc);
                break;
            }
            case ROOK: {
                newPiece = new Rook(board, pos, pc);
                break;
            }
            case QUEEN: {
                newPiece = new Queen(board, pos, pc);
            }
        }
        newPiece.designator = type.designator;
        newPiece.getImage();
        return newPiece;
    }

    final PieceColor getColor() {
        return this.color;
    }

    final char getDesignator() {
        return this.designator;
    }

    final void setDraggedPosition(DraggedPosition pos) {
        this.posWhenDragged = pos;
    }

    final TilePosition getTilePosition() {
        return this.position;
    }

    final boolean hasMoved() {
        return this.hasMoved;
    }

    final void setHasMoved() {
        this.hasMoved = true;
    }

    final void makeDragged() {
        this.isCurrentlyDragged = true;
    }

    final void makeNotDragged() {
        this.isCurrentlyDragged = false;
    }

    final void remove() {
        this.tile.setInhabitant(null);
    }

    final boolean isMine() {
        return (this.board.orientationAsWhite() ? PieceColor.White : PieceColor.Black) == this.color;
    }

    final boolean isControlled(TilePosition pos) {
        return this.isMine() ? this.board.isControlled(pos) : this.board.isControlledByOpponent(pos);
    }

    final boolean isControlledByOpponent(TilePosition pos) {
        return !this.isMine() ? this.board.isControlled(pos) : this.board.isControlledByOpponent(pos);
    }

    final boolean isMobile() {
        return !this.isControlledByOpponent(this.position);
    }

    void moveTo(TilePosition destination) {
        this.position = destination;
        this.tile.setInhabitant(null);
        this.tile = this.board.tile(destination);
        this.tile.setInhabitant(this);
        this.hasMoved = true;
    }

    PieceType getPromotionType(TilePosition target) {
        return null;
    }

    boolean canGoTo(TilePosition destination) {
        return this.computeAttacks().contains(destination) && this.isControlled(destination);
    }

    final boolean canMoveAtAll() {
        if (!this.isMobile()) {
            return false;
        }
        for (TilePosition pos : this.computeAttacks()) {
            if (!this.canGoTo(pos)) continue;
            return true;
        }
        return false;
    }

    final void paint(Graphics g) {
        if (!this.isCurrentlyDragged) {
            g.drawImage(this.appearance, this.position.x * this.SIZE, this.position.y * this.SIZE, null);
        } else {
            g.drawImage(this.appearance, this.posWhenDragged.x, this.posWhenDragged.y, null);
        }
    }

    final TilePosition p(int x, int y) {
        return new TilePosition(x, y);
    }

    final boolean isFree(TilePosition pos) {
        return this.board.isFree(pos);
    }

    final boolean pieceIsOfOppositeColor(TilePosition pos) {
        return this.board.inhabitant(pos).isMine() != this.isMine();
    }

    final boolean isLegitimateTarget(TilePosition pos) {
        return pos.isLegal() && (this.isFree(pos) || this.pieceIsOfOppositeColor(pos));
    }
}

