/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

class Pawn
extends Piece {
    private Board board;
    private final int initialRow;
    private boolean justMovedTwoSquares = false;

    Pawn(Board board, TilePosition pos, PieceColor pc) {
        super(board, pos, pc);
        this.board = board;
        this.initialRow = this.isMine() ? 6 : 1;
    }

    @Override
    void moveTo(TilePosition destination) {
        if (Math.abs(this.getTilePosition().y - destination.y) > 1) {
            this.justMovedTwoSquares = true;
        }
        if (this.isEnPassant(destination)) {
            this.removePawnForEnPassant(destination);
        }
        super.moveTo(destination);
    }

    @Override
    PieceType getPromotionType(TilePosition target) {
        PieceType promotionType = null;
        if (target.isFinalRank()) {
            promotionType = this.promotionChoice();
        }
        return promotionType;
    }

    @Override
    boolean canGoTo(TilePosition destination) {
        if (destination.y == this.getTilePosition().y) {
            return false;
        }
        if (destination.x != this.getTilePosition().x && this.isFree(destination)) {
            TilePosition enPassantVictim = this.p(destination.x, this.getTilePosition().y);
            return super.canGoTo(destination) && this.isControlled(enPassantVictim);
        }
        return super.canGoTo(destination);
    }

    @Override
    ArrayList<TilePosition> computeAttacks() {
        int row = this.getTilePosition().y;
        int file = this.getTilePosition().x;
        int rowInFront = this.isMine() ? row - 1 : row + 1;
        int twoRowsInFront = this.isMine() ? row - 2 : row + 2;
        ArrayList<TilePosition> result = new ArrayList<TilePosition>();
        TilePosition frontPos = new TilePosition(file, rowInFront);
        TilePosition leftFrontPos = new TilePosition(file - 1, rowInFront);
        TilePosition rightFrontPos = new TilePosition(file + 1, rowInFront);
        TilePosition leftSidePos = new TilePosition(file - 1, row);
        TilePosition rightSidePos = new TilePosition(file + 1, row);
        TilePosition twoInFrontPos = new TilePosition(file, twoRowsInFront);
        if (this.isFree(frontPos)) {
            result.add(frontPos);
        }
        if (this.isLegitimateTarget(leftFrontPos) && !this.isFree(leftFrontPos)) {
            result.add(leftFrontPos);
        }
        if (this.isLegitimateTarget(rightFrontPos) && !this.isFree(rightFrontPos)) {
            result.add(rightFrontPos);
        }
        if (this.otherPawnJustMovedTwoSquares(leftSidePos)) {
            result.add(leftFrontPos);
            result.add(leftSidePos);
        }
        if (this.otherPawnJustMovedTwoSquares(rightSidePos)) {
            result.add(rightFrontPos);
            result.add(rightSidePos);
        }
        if (row == this.initialRow && this.isFree(twoInFrontPos) && this.isFree(frontPos)) {
            result.add(twoInFrontPos);
        }
        return result;
    }

    boolean isEnPassant(TilePosition destination) {
        return destination.x != this.getTilePosition().x && this.isFree(destination);
    }

    void resetJustMovedTwoSquares() {
        this.justMovedTwoSquares = false;
    }

    private void removePawnForEnPassant(TilePosition destination) {
        Tile tile = this.board.tile(new TilePosition(destination.x, this.getTilePosition().y));
        tile.getInhabitant().remove();
    }

    private PieceType promotionChoice() {
        PieceType[] choices = new PieceType[]{PieceType.KNIGHT, PieceType.BISHOP, PieceType.ROOK, PieceType.QUEEN};
        int numberOfChoices = choices.length;
        Object[] imageIcons = new ImageIcon[numberOfChoices];
        for (int possibleChoice = 0; possibleChoice < numberOfChoices; ++possibleChoice) {
            imageIcons[possibleChoice] = new ImageIcon(Piece.getPieceImage(this.getColor(), choices[possibleChoice].designator));
        }
        int defaultChoice = 3;
        int selectedValue = JOptionPane.showOptionDialog(this.board.getBoardGraphics(), null, "Promotion", -1, 1, new ImageIcon(), imageIcons, imageIcons[defaultChoice]);
        if (selectedValue < 0) {
            selectedValue = defaultChoice;
        }
        return choices[selectedValue];
    }

    private boolean otherPawnJustMovedTwoSquares(TilePosition pos) {
        if (!pos.isLegal()) {
            return false;
        }
        Piece thePiece = this.board.inhabitant(pos);
        return thePiece instanceof Pawn && ((Pawn)thePiece).justMovedTwoSquares && this.pieceIsOfOppositeColor(pos);
    }
}

