/*
 * Decompiled with CFR 0.152.
 */
class Move {
    private final TilePosition source;
    private final TilePosition target;
    private final Board board;
    private final Piece thePiece;
    private final PieceType promoteTo;
    private static int moveNumber;
    private final String separator;
    private final boolean isEnPassant;
    private final boolean isCastleShort;
    private final boolean isCastleLong;

    Move(TilePosition source, TilePosition target, PieceType promoteTo, Board board) {
        this.source = source;
        this.target = target;
        this.board = board;
        this.promoteTo = promoteTo;
        this.thePiece = board.inhabitant(source);
        this.isEnPassant = this.thePiece instanceof Pawn && ((Pawn)this.thePiece).isEnPassant(target);
        this.isCastleShort = this.thePiece instanceof King && ((King)this.thePiece).isCastleShort(target);
        this.isCastleLong = this.thePiece instanceof King && ((King)this.thePiece).isCastleLong(target);
        this.separator = !board.tile(target).isFree() || this.isEnPassant ? "x" : "-";
        board.updateLameMoves(this.thePiece, target);
    }

    static void resetMoveNumber() {
        moveNumber = 1;
    }

    void execute() {
        this.resetAllJustMovedTwoSquares();
        this.thePiece.moveTo(this.target);
        if (this.isPromotion()) {
            this.promote();
        }
        this.resetMoveMarks();
    }

    String twoMovesToString(Move theMove) {
        String myMove = this.toString();
        String otherMove = theMove.toString();
        if (this.board.getFogOfWar()) {
            otherMove = "-------";
        }
        String result = this.thePiece.getColor() == PieceColor.Black ? otherMove + " " + myMove + "\n" : myMove + " " + otherMove + "\n";
        result = this.moveNumberToString() + ". " + result;
        ++moveNumber;
        return result;
    }

    public String toString() {
        if (this.isCastleShort) {
            return "0-0   ";
        }
        if (this.isCastleLong) {
            return "0-0-0 ";
        }
        Object result = "";
        if (!(this.thePiece instanceof Pawn)) {
            result = (String)result + this.thePiece.getDesignator();
        }
        result = (String)result + this.board.tile(this.source).getName();
        result = (String)result + this.separator;
        result = (String)result + this.board.tile(this.target).getName();
        if (this.isPromotion()) {
            result = (String)result + this.promoteTo.designator;
        } else if (this.thePiece instanceof Pawn) {
            result = (String)result + " ";
        }
        return result;
    }

    private boolean isPromotion() {
        return this.promoteTo != null;
    }

    private void promote() {
        Piece.pieceFactory(this.board, this.target, this.promoteTo, this.thePiece.getColor());
    }

    private void resetMoveMarks() {
        for (Tile tile : this.board.getAllTiles()) {
            tile.eraseMarkForLastMove();
        }
        this.board.tile(this.source).markForLastMove();
        this.board.tile(this.target).markForLastMove();
    }

    private void resetAllJustMovedTwoSquares() {
        for (Tile tile : this.board.getAllTiles()) {
            Piece inhabitant = tile.getInhabitant();
            if (!(inhabitant instanceof Pawn) || this.thePiece.getColor() != inhabitant.getColor()) continue;
            ((Pawn)inhabitant).resetJustMovedTwoSquares();
        }
    }

    private String moveNumberToString() {
        if (moveNumber < 10) {
            return "  " + moveNumber;
        }
        if (moveNumber < 100) {
            return " " + moveNumber;
        }
        return "" + moveNumber;
    }
}

