/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;

abstract class LinePiece
extends Piece {
    final TilePosition[] bishopDirections = new TilePosition[]{this.p(1, 1), this.p(1, -1), this.p(-1, 1), this.p(-1, -1)};
    final TilePosition[] rookDirections = new TilePosition[]{this.p(0, 1), this.p(0, -1), this.p(-1, 0), this.p(1, 0)};

    LinePiece(Board board, TilePosition pos, PieceColor pc) {
        super(board, pos, pc);
    }

    abstract TilePosition[] getDirections();

    @Override
    ArrayList<TilePosition> computeAttacks() {
        ArrayList<TilePosition> result = new ArrayList<TilePosition>();
        for (TilePosition direction : this.getDirections()) {
            result.addAll(this.attacksInOneDirection(direction));
        }
        return result;
    }

    private final ArrayList<TilePosition> attacksInOneDirection(TilePosition direction) {
        ArrayList<TilePosition> result = new ArrayList<TilePosition>();
        TilePosition nextPos = new TilePosition(this.getTilePosition().x, this.getTilePosition().y);
        while ((nextPos = nextPos.add(direction)).isLegal()) {
            if (!this.isFree(nextPos)) {
                if (!this.pieceIsOfOppositeColor(nextPos)) break;
                result.add(nextPos);
                break;
            }
            result.add(nextPos);
        }
        return result;
    }
}

