/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;

class King
extends KingOrKnight {
    private int castleShortDirection;
    private Board board;

    King(Board board, TilePosition pos, PieceColor pc) {
        super(board, pos, pc);
        this.castleShortDirection = board.orientationAsWhite() ? 1 : -1;
        this.board = board;
    }

    @Override
    ArrayList<TilePosition> computeAttacks() {
        TilePosition[] displacements = new TilePosition[]{this.p(1, 1), this.p(1, 0), this.p(1, -1), this.p(0, 1), this.p(0, -1), this.p(-1, 1), this.p(-1, 0), this.p(-1, -1)};
        ArrayList<TilePosition> attacks = super.computeAttacks(displacements);
        for (int displacement = -2; displacement < 5; displacement += 4) {
            TilePosition possibleDest = this.possibleCastleDestination(displacement);
            if (possibleDest == null) continue;
            attacks.add(possibleDest);
        }
        return attacks;
    }

    @Override
    boolean canGoTo(TilePosition destination) {
        if (super.canGoTo(destination) && this.isCastle(destination)) {
            return this.findRookForCastle(destination).isMobile() && this.isControlled(this.findRookDestination(destination)) && this.isControlled(destination);
        }
        return super.canGoTo(destination);
    }

    @Override
    void moveTo(TilePosition destination) {
        if (this.isCastle(destination)) {
            this.moveRookForCastle(destination);
        }
        super.moveTo(destination);
    }

    boolean isCastleShort(TilePosition destination) {
        return this.getTilePosition().x - destination.x == -2 * this.castleShortDirection;
    }

    boolean isCastleLong(TilePosition destination) {
        return this.getTilePosition().x - destination.x == 2 * this.castleShortDirection;
    }

    private int castleDirection(TilePosition castleDestination) {
        return this.getTilePosition().x < castleDestination.x ? 1 : -1;
    }

    private boolean isCastle(TilePosition destination) {
        return this.isCastleShort(destination) || this.isCastleLong(destination);
    }

    private Piece findRookForCastle(TilePosition destination) {
        int distanceToRook = this.isCastleShort(destination) ? 3 * this.castleShortDirection : -4 * this.castleShortDirection;
        return this.board.inhabitant(this.p(this.getTilePosition().x + distanceToRook, destination.y));
    }

    private TilePosition findRookDestination(TilePosition destination) {
        return this.p(this.getTilePosition().x + this.castleDirection(destination), destination.y);
    }

    private TilePosition findNextToRook(TilePosition destination) {
        int length = this.isCastleShort(destination) ? 2 * this.castleShortDirection : -3 * this.castleShortDirection;
        return this.p(this.getTilePosition().x + length, destination.y);
    }

    private TilePosition possibleCastleDestination(int kingDisplacement) {
        if (this.hasMoved()) {
            return null;
        }
        int xDestination = this.getTilePosition().x + kingDisplacement;
        TilePosition destination = this.p(xDestination, this.getTilePosition().y);
        Piece theRook = this.findRookForCastle(destination);
        if (theRook != null && !theRook.hasMoved() && this.isFree(destination) && this.isFree(this.findRookDestination(destination)) && this.isFree(this.findNextToRook(destination))) {
            return destination;
        }
        return null;
    }

    private void moveRookForCastle(TilePosition destination) {
        Piece theRook = this.findRookForCastle(destination);
        theRook.moveTo(this.findRookDestination(destination));
    }
}

