/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.concurrent.Semaphore;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class GUI {
    private final Player thePlayer;
    private final TextArea recording;
    private final JFrame theFrame = new JFrame("Parrow's Synchronous Chess 1.2.1");
    private final JPanel topPanel = new JPanel();
    private final JPanel bottomPanel = new JPanel();
    private final JButton offerDrawButton = new JButton("Offer Draw");
    private final JButton resignButton = new JButton("Resign");
    private final JButton acceptButton = new JButton("Accept");
    private final JButton rejectButton = new JButton("Reject");
    private final JButton goButton = new JButton("Go again");
    private Clip alert;
    private boolean playAlertSound = false;
    private Semaphore swingLock = new Semaphore(1);

    private void waitForSwingLock() {
        this.swingLock.acquireUninterruptibly();
    }

    private void releaseSwingLock() {
        this.swingLock.release();
    }

    GUI(Player thePlayer) {
        this.thePlayer = thePlayer;
        this.theFrame.setLayout(new BorderLayout());
        this.theFrame.setDefaultCloseOperation(3);
        this.theFrame.add((Component)thePlayer.getBoard().getBoardGraphics(), "Center");
        this.recording = new TextArea(10, 20);
        this.recording.setEditable(false);
        this.recording.setFont(new Font("Courier", 0, 16));
        this.recording.setBackground(new Color(230, 204, 179));
        this.theFrame.add((Component)this.recording, "East");
        this.getAlertSound();
        this.setButtonListeners();
        this.theFrame.setVisible(true);
        this.showTitle();
    }

    private void getAlertSound() {
        try {
            InputStream alertInputStream = Main.class.getResourceAsStream("/alert.wav");
            BufferedInputStream bufferedAlertInputStream = new BufferedInputStream(alertInputStream);
            AudioInputStream audioAlert = AudioSystem.getAudioInputStream(bufferedAlertInputStream);
            this.alert = AudioSystem.getClip();
            this.alert.open(audioAlert);
            this.playAlertSound = true;
        }
        catch (Exception e) {
            System.out.println("No alert sound :(");
            this.playAlertSound = false;
            this.alert = null;
            System.out.println(e);
        }
    }

    private void setButtonListeners() {
        this.resignButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUI.this.thePlayer.resign();
            }
        });
        this.offerDrawButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUI.this.thePlayer.offerDraw();
            }
        });
        this.acceptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUI.this.thePlayer.acceptDraw();
            }
        });
        this.rejectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUI.this.thePlayer.rejectDraw();
            }
        });
        this.goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUI.this.thePlayer.goAgain();
            }
        });
    }

    void close() {
        this.theFrame.dispose();
    }

    void playClick() {
        this.alert.setFramePosition(0);
        this.alert.start();
    }

    void record(String text) {
        this.recording.append(text);
        if (this.playAlertSound) {
            this.playClick();
        }
    }

    boolean confirmResign() {
        int reply = JOptionPane.showConfirmDialog(this.theFrame, "Are you sure you want to resign?", "Resignation?", 0);
        return reply == 0;
    }

    void showDisagreement(String reason) {
        JOptionPane.showMessageDialog(this.theFrame, "Failed: " + reason);
    }

    void showTitle() {
        this.waitForSwingLock();
        this.topPanel.removeAll();
        this.topPanel.setBackground(Color.black);
        this.theFrame.add((Component)this.topPanel, "North");
        JLabel title = new JLabel("PSC: Parrow's Synchronous Chess");
        title.setForeground(Color.white);
        title.setFont(new Font("TimesRoman", 1, 26));
        this.topPanel.add(title);
        this.topPanel.add(this.resignButton);
        this.topPanel.add(this.offerDrawButton);
        this.finalizeShow();
    }

    void showFinal(String verdict) {
        this.waitForSwingLock();
        this.topPanel.removeAll();
        JLabel theText = new JLabel(verdict);
        theText.setFont(new Font("TimesRoman", 1, 32));
        this.topPanel.setBackground(Color.red);
        theText.setForeground(Color.white);
        this.topPanel.add(theText);
        this.thePlayer.stopGettingMoves();
        this.topPanel.add(this.goButton);
        this.finalizeShow();
    }

    private void showOffer(String reason) {
        this.waitForSwingLock();
        this.topPanel.removeAll();
        JLabel theText = new JLabel(reason);
        theText.setFont(new Font("TimesRoman", 1, 26));
        this.topPanel.setBackground(Color.blue);
        theText.setForeground(Color.white);
        this.topPanel.add(theText);
    }

    void showDrawOffer() {
        this.showOffer("Draw?");
        this.topPanel.add(this.acceptButton);
        this.topPanel.add(this.rejectButton);
        this.finalizeShow();
    }

    void showYouOfferDraw() {
        this.showOffer("You Offer Draw");
        this.finalizeShow();
    }

    void showTime(Boolean isRunning, String time, String opponentTime) {
        this.waitForSwingLock();
        this.bottomPanel.removeAll();
        Color backgroundColor = isRunning != false ? Color.RED : Color.WHITE;
        this.bottomPanel.setBackground(backgroundColor);
        this.theFrame.add((Component)this.bottomPanel, "South");
        JLabel myTime = new JLabel("Time left  " + time);
        this.bottomPanel.setForeground(Color.black);
        myTime.setFont(new Font("TimesRoman", 1, 36));
        JLabel oppTime = new JLabel("               Time left for opponent  " + opponentTime);
        oppTime.setFont(new Font("TimesRoman", 1, 24));
        this.bottomPanel.add(myTime);
        if (!this.thePlayer.getFogOfWar()) {
            this.bottomPanel.add(oppTime);
        }
        this.finalizeShow();
    }

    private void finalizeShow() {
        this.theFrame.pack();
        this.theFrame.repaint();
        this.releaseSwingLock();
    }
}

