/*
 * Decompiled with CFR 0.152.
 */
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class Communicator {
    private ObjectInputStream inputFromOpponent;
    private ObjectOutputStream outputToOpponent;
    private final Player thePlayer;
    private MoveListener myMoveListener = new MoveListener();

    Communicator(ObjectInputStream is, ObjectOutputStream os, Player thePlayer) {
        this.thePlayer = thePlayer;
        this.inputFromOpponent = is;
        this.outputToOpponent = os;
    }

    InitialMessage getInitialMessage() {
        try {
            InitialMessage message = (InitialMessage)this.inputFromOpponent.readObject();
            return message;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.thePlayer.commError(" failed initial message");
            return null;
        }
    }

    void sendInitialMessage(InitialMessage message) {
        try {
            this.outputToOpponent.writeObject(message);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            this.thePlayer.commError(" sending initial message");
        }
    }

    PieceColor getColor() {
        try {
            PieceColor color = (PieceColor)((Object)this.inputFromOpponent.readObject());
            return color;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.thePlayer.commError(" setting up colors");
            return null;
        }
    }

    void sendColor(PieceColor color) {
        try {
            this.outputToOpponent.writeObject((Object)color);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            this.thePlayer.commError(" sending color");
        }
    }

    void sendMove(Message message) {
        try {
            this.outputToOpponent.writeObject(message);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            this.thePlayer.commError(" sending move");
        }
    }

    void startToListenForMoves() {
        this.myMoveListener.start();
    }

    void stopListening() {
        this.myMoveListener.stopListening();
    }

    private class MoveListener
    extends Thread {
        boolean running = true;

        private MoveListener() {
        }

        @Override
        public void run() {
            Message message = null;
            while (this.running) {
                try {
                    try {
                        message = (Message)Communicator.this.inputFromOpponent.readObject();
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                        this.running = false;
                    }
                    catch (EOFException e) {
                        this.running = false;
                    }
                    if (!this.running || message == null) continue;
                    Communicator.this.thePlayer.getMessageFromOpponent(message);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.running = false;
                }
            }
        }

        void stopListening() {
            this.running = false;
        }
    }
}

