/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.concurrent.Semaphore;
import javax.swing.JPanel;

class Board {
    static final int TILESIZE = 60;
    private final PieceColor orientation;
    private final Tile[][] tileTable = new Tile[8][8];
    private final ArrayList<Tile> allTiles = new ArrayList();
    private final Player thePlayer;
    private final ComputeControl theComputeControl = new ComputeControl();
    private final BoardGraphics boardGraphics = new BoardGraphics();
    private final Semaphore lock = new Semaphore(1);
    private King myKing;
    private King opponentKing;
    private Move opponentMove;
    private Move myMove;
    private int numberOfLameMoves = 0;
    private boolean gettingMoves = false;
    private final int maxNumberOfLameMoves = 50;

    Board(PieceColor myColor, Player thePlayer) {
        this.thePlayer = thePlayer;
        this.orientation = myColor;
        this.setUpTiles();
        this.createStartPosition();
        this.theComputeControl.computeControls();
        this.boardGraphics.repaint();
        this.startGettingMoves();
    }

    private void setUpTiles() {
        for (int fileNumber = 0; fileNumber < 8; ++fileNumber) {
            for (int rowNumber = 0; rowNumber < 8; ++rowNumber) {
                Tile tile;
                this.tileTable[fileNumber][rowNumber] = tile = new Tile(new TilePosition(fileNumber, rowNumber), this.tileName(fileNumber, rowNumber));
                this.allTiles.add(tile);
            }
        }
    }

    private String tileName(int x, int y) {
        int file = this.orientationAsWhite() ? x : 7 - x;
        int row = this.orientationAsWhite() ? y : 7 - y;
        String rows = "87654321";
        String files = "abcdefgh";
        return String.valueOf("abcdefgh".charAt(file)) + "87654321".charAt(row);
    }

    private void createStartPosition() {
        PieceColor opponentColor = this.orientation.opposite();
        PieceType[] initialRow = new PieceType[]{PieceType.ROOK, PieceType.KNIGHT, PieceType.BISHOP, PieceType.QUEEN, PieceType.KING, PieceType.BISHOP, PieceType.KNIGHT, PieceType.ROOK};
        int kingFile = 4;
        if (!this.orientationAsWhite()) {
            initialRow[3] = PieceType.KING;
            initialRow[4] = PieceType.QUEEN;
            kingFile = 3;
        }
        int file = 0;
        for (PieceType type : initialRow) {
            Piece.pieceFactory(this, new TilePosition(file, 0), type, opponentColor);
            Piece.pieceFactory(this, new TilePosition(file, 1), PieceType.PAWN, opponentColor);
            Piece.pieceFactory(this, new TilePosition(file, 6), PieceType.PAWN, this.orientation);
            Piece.pieceFactory(this, new TilePosition(file, 7), type, this.orientation);
            ++file;
        }
        this.myKing = (King)this.inhabitant(new TilePosition(kingFile, 7));
        this.opponentKing = (King)this.inhabitant(new TilePosition(kingFile, 0));
    }

    boolean orientationAsWhite() {
        return this.orientation == PieceColor.White;
    }

    Tile tile(TilePosition pos) {
        return this.tileTable[pos.x][pos.y];
    }

    Piece inhabitant(TilePosition pos) {
        return this.tile(pos).getInhabitant();
    }

    boolean isControlled(TilePosition pos) {
        return this.tile(pos).isControlled();
    }

    boolean isControlledByOpponent(TilePosition pos) {
        return this.tile(pos).isControlledByOpponent();
    }

    boolean isFree(TilePosition pos) {
        return this.tile(pos).isFree();
    }

    ArrayList<Tile> getAllTiles() {
        return this.allTiles;
    }

    boolean getFogOfWar() {
        return this.thePlayer.getFogOfWar();
    }

    BoardGraphics getBoardGraphics() {
        return this.boardGraphics;
    }

    void startGettingMoves() {
        if (!this.gettingMoves) {
            this.boardGraphics.startListening();
            this.gettingMoves = true;
        }
    }

    void stopGettingMoves() {
        this.boardGraphics.stopListening();
        this.gettingMoves = false;
    }

    void reactivate() {
        if (!this.iHaveMoved()) {
            this.startGettingMoves();
        }
    }

    void updateLameMoves(Piece thePiece, TilePosition target) {
        this.numberOfLameMoves = this.isLameMove(thePiece, target) ? ++this.numberOfLameMoves : 0;
    }

    void makeAllVisible() {
        for (Tile tile : this.allTiles) {
            tile.makeVisible();
        }
        this.boardGraphics.repaint();
    }

    void incomingMoveFromOpponent(Move theMove) {
        if (this.iHaveMoved()) {
            this.waitForLock();
            theMove.execute();
            this.record(this.myMove, theMove);
            this.myMove = null;
            this.theComputeControl.computeControls();
            this.boardGraphics.repaint();
            this.startGettingMoves();
            this.releaseLock();
        } else {
            this.opponentMove = theMove;
            this.thePlayer.startClock();
        }
    }

    private void makeMyMove(TilePosition target, Piece thePiece) {
        if (thePiece.canGoTo(target)) {
            PieceType promoteTo = thePiece.getPromotionType(target);
            TilePosition source = thePiece.getTilePosition();
            Move theMove = new Move(source, target, promoteTo, this);
            this.thePlayer.sendMoveToOpponent(source.transpose(), target.transpose(), promoteTo);
            theMove.execute();
            if (this.opponentHasMoved()) {
                this.opponentMove.execute();
                this.record(theMove, this.opponentMove);
                this.opponentMove = null;
                this.thePlayer.stopClock();
                this.theComputeControl.computeControls();
            } else {
                this.stopGettingMoves();
                this.myMove = theMove;
            }
        }
        this.boardGraphics.repaint();
    }

    private boolean opponentHasMoved() {
        return this.opponentMove != null;
    }

    private boolean iHaveMoved() {
        return this.myMove != null;
    }

    private void waitForLock() {
        this.lock.acquireUninterruptibly();
    }

    private void releaseLock() {
        this.lock.release();
    }

    private boolean isLameMove(Piece thePiece, TilePosition target) {
        return !(thePiece instanceof Pawn) && this.isFree(target);
    }

    private void record(Move move1, Move move2) {
        this.thePlayer.record(move1.twoMovesToString(move2));
    }

    private void createCastleTestStartPosition() {
        int kingFile = this.orientationAsWhite() ? 4 : 3;
        PieceColor opponentColor = this.orientation.opposite();
        Piece.pieceFactory(this, new TilePosition(0, 0), PieceType.ROOK, opponentColor);
        Piece.pieceFactory(this, new TilePosition(7, 0), PieceType.ROOK, opponentColor);
        Piece.pieceFactory(this, new TilePosition(0, 7), PieceType.ROOK, this.orientation);
        Piece.pieceFactory(this, new TilePosition(7, 7), PieceType.ROOK, this.orientation);
        Piece.pieceFactory(this, new TilePosition(kingFile, 0), PieceType.KING, opponentColor);
        Piece.pieceFactory(this, new TilePosition(kingFile, 7), PieceType.KING, this.orientation);
        Piece.pieceFactory(this, new TilePosition(1, 0), PieceType.KNIGHT, opponentColor);
        Piece.pieceFactory(this, new TilePosition(6, 0), PieceType.KNIGHT, opponentColor);
        Piece.pieceFactory(this, new TilePosition(1, 7), PieceType.KNIGHT, this.orientation);
        Piece.pieceFactory(this, new TilePosition(6, 7), PieceType.KNIGHT, this.orientation);
        this.myKing = (King)this.inhabitant(new TilePosition(kingFile, 7));
        this.opponentKing = (King)this.inhabitant(new TilePosition(kingFile, 0));
    }

    private void createAlternateStartPosition() {
        int kingFile = 7;
        if (!this.orientationAsWhite()) {
            kingFile = 0;
        }
        PieceColor opponentColor = this.orientation.opposite();
        Piece.pieceFactory(this, new TilePosition(kingFile, 0), PieceType.KING, opponentColor);
        Piece.pieceFactory(this, new TilePosition(kingFile, 7), PieceType.KING, this.orientation);
        this.myKing = (King)this.inhabitant(new TilePosition(kingFile, 7));
        this.myKing.setHasMoved();
        this.opponentKing = (King)this.inhabitant(new TilePosition(kingFile, 0));
        this.opponentKing.setHasMoved();
        Piece.pieceFactory(this, new TilePosition(kingFile, 2), PieceType.KNIGHT, opponentColor);
        Piece.pieceFactory(this, new TilePosition(kingFile, 3), PieceType.KNIGHT, opponentColor);
        Piece.pieceFactory(this, new TilePosition(kingFile, 4), PieceType.KNIGHT, this.orientation);
        Piece.pieceFactory(this, new TilePosition(kingFile, 5), PieceType.KNIGHT, this.orientation);
        Piece.pieceFactory(this, new TilePosition(3, 1), PieceType.PAWN, opponentColor);
        Piece.pieceFactory(this, new TilePosition(2, 1), PieceType.PAWN, opponentColor);
        Piece.pieceFactory(this, new TilePosition(4, 6), PieceType.PAWN, this.orientation);
        Piece.pieceFactory(this, new TilePosition(5, 6), PieceType.PAWN, this.orientation);
    }

    private void createAlternateStartPositionTestPromotions() {
        int kingFile = 4;
        int pawnFile = 1;
        if (!this.orientationAsWhite()) {
            kingFile = 3;
            pawnFile = 6;
        }
        PieceColor opponentColor = this.orientation.opposite();
        this.opponentKing = (King)Piece.pieceFactory(this, new TilePosition(kingFile, 0), PieceType.KING, opponentColor);
        this.myKing = (King)Piece.pieceFactory(this, new TilePosition(kingFile, 7), PieceType.KING, this.orientation);
        Piece.pieceFactory(this, new TilePosition(pawnFile, 6), PieceType.PAWN, opponentColor);
        Piece.pieceFactory(this, new TilePosition(pawnFile, 1), PieceType.PAWN, this.orientation);
    }

    private void createTestPos() {
        PieceColor opponentColor = this.orientation.opposite();
        TilePosition WKingPos = new TilePosition(2, 6);
        TilePosition BKingPos = new TilePosition(0, 7);
        TilePosition WQPos = new TilePosition(1, 4);
        if (!this.orientationAsWhite()) {
            WKingPos = WKingPos.transpose();
            WQPos = WQPos.transpose();
            BKingPos = BKingPos.transpose();
            this.myKing = (King)Piece.pieceFactory(this, BKingPos, PieceType.KING, PieceColor.Black);
            this.opponentKing = (King)Piece.pieceFactory(this, WKingPos, PieceType.KING, PieceColor.White);
            Piece.pieceFactory(this, WQPos, PieceType.QUEEN, PieceColor.White);
        } else {
            this.myKing = (King)Piece.pieceFactory(this, WKingPos, PieceType.KING, PieceColor.White);
            this.opponentKing = (King)Piece.pieceFactory(this, BKingPos, PieceType.KING, PieceColor.Black);
            Piece.pieceFactory(this, WQPos, PieceType.QUEEN, PieceColor.White);
        }
    }

    private class BoardGraphics
    extends JPanel {
        static final int TILESIZE = 60;
        private MyMouseListener theMouseListener = new MyMouseListener();

        BoardGraphics() {
            this.setPreferredSize(new Dimension(480, 480));
            this.setUpControlShowToggle();
        }

        private void startListening() {
            this.addMouseListener(this.theMouseListener);
            this.addMouseMotionListener(this.theMouseListener);
        }

        private void stopListening() {
            this.removeMouseListener(this.theMouseListener);
            this.removeMouseMotionListener(this.theMouseListener);
        }

        private void setUpControlShowToggle() {
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 32 && !Board.this.thePlayer.getFogOfWar()) {
                        for (Tile tile : Board.this.allTiles) {
                            tile.toggleShowControl();
                        }
                        BoardGraphics.this.repaint();
                    }
                }
            });
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            for (Tile tile : Board.this.allTiles) {
                tile.paint(g);
            }
            if (this.theMouseListener.isDragging()) {
                this.theMouseListener.currentlyDraggedPiece.paint(g);
            }
            if (Board.this.iHaveMoved()) {
                g.setColor(new Color(100, 100, 100, 100));
                g.fillRect(0, 0, 480, 480);
            }
            this.requestFocus();
        }

        private class MyMouseListener
        implements MouseListener,
        MouseMotionListener {
            private Piece currentlyDraggedPiece = null;

            private MyMouseListener() {
            }

            private boolean isDragging() {
                return this.currentlyDraggedPiece != null;
            }

            private void removeCurrentlyDraggedPiece() {
                if (this.isDragging()) {
                    this.currentlyDraggedPiece.makeNotDragged();
                    this.currentlyDraggedPiece = null;
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Board.this.waitForLock();
                Tile tile = this.getTile(mouseEvent);
                if (tile.hasMovablePiece()) {
                    this.currentlyDraggedPiece = tile.getInhabitant();
                    this.currentlyDraggedPiece.makeDragged();
                    this.placeCurrentlyDraggedPiece(mouseEvent);
                }
                Board.this.releaseLock();
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                Board.this.waitForLock();
                if (this.isDragging()) {
                    TilePosition target = this.getDraggedPosition(mouseEvent).tilePosition();
                    Board.this.makeMyMove(target, this.currentlyDraggedPiece);
                    this.removeCurrentlyDraggedPiece();
                }
                Board.this.releaseLock();
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                Board.this.waitForLock();
                this.placeCurrentlyDraggedPiece(mouseEvent);
                Board.this.releaseLock();
            }

            private void placeCurrentlyDraggedPiece(MouseEvent mouseEvent) {
                if (this.isDragging()) {
                    this.currentlyDraggedPiece.setDraggedPosition(new DraggedPosition(mouseEvent.getX() - 30, mouseEvent.getY() - 30));
                    BoardGraphics.this.repaint();
                }
            }

            private DraggedPosition getDraggedPosition(MouseEvent mouseEvent) {
                return new DraggedPosition(mouseEvent.getX(), mouseEvent.getY());
            }

            private Tile getTile(MouseEvent mouseEvent) {
                TilePosition pos = this.getDraggedPosition(mouseEvent).tilePosition();
                return Board.this.tile(pos);
            }
        }
    }

    private class ComputeControl {
        private boolean myKingIsAttacked;
        private boolean opponentKingIsAttacked;

        private ComputeControl() {
        }

        private void attackFrom(Tile tile) {
            if (!tile.isFree()) {
                Piece attackingPiece = tile.getInhabitant();
                ArrayList<TilePosition> attackedPositions = attackingPiece.computeAttacks();
                attackedPositions.add(attackingPiece.getTilePosition());
                int increment = attackingPiece.isMine() ? 1 : -1;
                for (TilePosition attackedPos : attackedPositions) {
                    Board.this.tile(attackedPos).addControl(increment);
                    Piece attackedPiece = Board.this.tile(attackedPos).getInhabitant();
                    if (attackingPiece != Board.this.myKing && attackedPiece == Board.this.myKing) {
                        this.myKingIsAttacked = true;
                    }
                    if (attackingPiece != Board.this.opponentKing && attackedPiece == Board.this.opponentKing) {
                        this.opponentKingIsAttacked = true;
                    }
                    if (!attackingPiece.isMine()) continue;
                    Board.this.tile(attackedPos).makeVisible();
                }
            }
        }

        private void computeControls() {
            this.myKingIsAttacked = false;
            this.opponentKingIsAttacked = false;
            for (Tile tile : Board.this.allTiles) {
                tile.setZeroControl();
                if (Board.this.getFogOfWar()) {
                    tile.makeInvisible();
                    continue;
                }
                tile.makeVisible();
            }
            for (Tile tile : Board.this.allTiles) {
                this.attackFrom(tile);
            }
            this.appraise();
        }

        private boolean stalemated(boolean checkMyPieces) {
            for (Tile tile : Board.this.allTiles) {
                Piece inhabitant;
                if (tile.isFree() || (inhabitant = tile.getInhabitant()).isMine() != checkMyPieces || !inhabitant.canMoveAtAll()) continue;
                return false;
            }
            return true;
        }

        private boolean passedLimitOfLameMoves() {
            return Board.this.numberOfLameMoves / 2 >= 50;
        }

        private void appraise() {
            boolean gameEnds;
            boolean myKingLost = !Board.this.myKing.isMobile();
            boolean opponentKingLost = !Board.this.opponentKing.isMobile();
            boolean iAmStalemated = this.stalemated(true);
            boolean opponentIsStalemated = this.stalemated(false);
            boolean iWin = opponentKingLost || opponentIsStalemated && this.opponentKingIsAttacked;
            boolean iLose = myKingLost || iAmStalemated && this.myKingIsAttacked;
            boolean bl = gameEnds = iWin || iLose || iAmStalemated || opponentIsStalemated || this.passedLimitOfLameMoves();
            if (gameEnds) {
                Board.this.makeAllVisible();
                Board.this.boardGraphics.repaint();
                if (iWin && iLose) {
                    Board.this.thePlayer.showDraw("Both lose");
                } else if (iLose) {
                    Board.this.thePlayer.showLose();
                } else if (iWin) {
                    Board.this.thePlayer.showWin();
                } else if (iAmStalemated || opponentIsStalemated) {
                    Board.this.thePlayer.showDraw("Stalemate");
                } else if (this.passedLimitOfLameMoves()) {
                    Board.this.thePlayer.showDraw("50 move rule");
                }
            }
        }
    }
}

